(function(){
  function ready(fn){ if(document.readyState!=='loading') fn(); else document.addEventListener('DOMContentLoaded', fn); }

  ready(function(){
    const gallery = document.querySelector('.gallery');
    if (!gallery) return;

    function resizeGridItems(){
      const items = gallery.querySelectorAll('.gallery a');
      const rowHeight = parseInt(window.getComputedStyle(gallery).getPropertyValue('grid-auto-rows'));
      const rowGap = parseInt(window.getComputedStyle(gallery).getPropertyValue('gap'));

      items.forEach(function(item){
        const img = item.querySelector('img');
        if (!img) return;
        
        const itemHeight = img.getBoundingClientRect().height;
        const rowSpan = Math.ceil((itemHeight + rowGap) / (rowHeight + rowGap));
        item.style.gridRowEnd = 'span ' + rowSpan;
      });
    }

    // Wait for images to load
    const images = gallery.querySelectorAll('img');
    let loadedCount = 0;
    
    images.forEach(function(img){
      if (img.complete) {
        loadedCount++;
      } else {
        img.addEventListener('load', function(){
          loadedCount++;
          if (loadedCount === images.length) {
            resizeGridItems();
          }
        });
      }
    });

    if (loadedCount === images.length) {
      resizeGridItems();
    }

    window.addEventListener('resize', resizeGridItems);
  });
})();

