#!/bin/bash

# Migration 004: Add Subscription Tiers Table
# This migrates Stripe Price IDs from environment variables to database

echo "========================================="
echo "Migration 004: Subscription Tiers Table"
echo "========================================="
echo ""

# Load environment variables
if [ -f .env ]; then
  export $(cat .env | grep -v '^#' | xargs)
fi

# Determine database connection
if [ -n "$DATABASE_URL" ]; then
  CONN="$DATABASE_URL"
elif [ -n "$DB_HOST" ]; then
  CONN="postgresql://${DB_USER:-postgres}:${DB_PASSWORD}@${DB_HOST}:${DB_PORT:-5432}/${DB_NAME:-photowebsite}"
else
  CONN="${DB_NAME:-photowebsite}"
fi

echo "📊 Running migration..."
echo ""

# Run the migration
psql "$CONN" -f migrations/004-add-subscription-tiers-table.sql

if [ $? -eq 0 ]; then
  echo ""
  echo "✅ Migration completed successfully!"
  echo ""
  echo "Next steps:"
  echo "1. Add your Stripe Price IDs to the database"
  echo "2. Restart the server"
  echo ""
  echo "See STRIPE-DATABASE-MIGRATION.md for details."
else
  echo ""
  echo "❌ Migration failed!"
  echo ""
  echo "Check your database connection and try again."
  exit 1
fi


