<?php

namespace App\Livewire\Account;

use Livewire\Component;
use Livewire\WithPagination;
use Illuminate\Support\Facades\Auth;

class Orders extends Component
{
    use WithPagination;

    public function render()
    {
        $orders = Auth::user()->orders()->latest()->paginate(10);

        return view('livewire.account.orders', [
            'orders' => $orders,
        ])->layout('layouts.shop');
    }
}


