<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('colourways', function (Blueprint $table) {
            $table->id();
            $table->foreignId('items_id')->constrained('items')->onDelete('cascade');
            $table->string('color_code')->nullable(); // Hex color code
            $table->string('image')->nullable(); // Colorway specific image
            $table->boolean('is_active')->default(true);
            $table->integer('sort_order')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('colourways');
    }
};
