<div>
    <div class="hero-section">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-8">
                    <h1 class="hero-title">Invoice Processing</h1>
                    <p class="hero-subtitle">Streamline your financial workflow with intelligent PDF invoice extraction</p>
                </div>
                <div class="col-lg-4 text-center">
                    <div class="bg-white bg-opacity-20 rounded-circle d-inline-flex align-items-center justify-content-center" style="width: 120px; height: 120px;">
                        <i class="bi bi-receipt-cutoff text-white" style="font-size: 3rem;"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="container">
    <!-- File Upload Section -->
    <div class="card mb-5">
        <div class="card-body p-5">
            <div class="text-center mb-4">
                <div class="bg-primary bg-opacity-10 rounded-circle d-inline-flex align-items-center justify-content-center mb-3" style="width: 80px; height: 80px;">
                    <i class="bi bi-cloud-upload text-primary" style="font-size: 2rem;"></i>
                </div>
                <h2 class="h3 fw-bold text-dark mb-2">Upload Your Invoice</h2>
                <p class="text-muted">Simply drag and drop or select your PDF invoice to get started</p>
            </div>
            
            <form wire:submit="processInvoice">
                <div class="mb-4">
                    <label for="pdfFile" class="form-label fw-semibold text-dark">
                        <i class="bi bi-file-earmark-pdf me-2 text-danger"></i>Select PDF Invoice
                    </label>
                    <input 
                        type="file" 
                        id="pdfFile" 
                        wire:model="pdfFile"
                        accept=".pdf"
                        class="form-control form-control-lg"
                    />
                    @error('pdfFile') 
                        <div class="alert alert-danger mt-3 d-flex align-items-center border-0" role="alert" style="border-radius: 12px;">
                            <i class="bi bi-exclamation-triangle-fill me-2"></i>
                            {{ $message }}
                        </div>
                    @enderror
                </div>

                <div class="text-center">
                    <button 
                        type="submit" 
                        class="btn btn-primary btn-lg px-5 py-3 fw-semibold"
                        wire:loading.attr="disabled"
                    >
                        <i wire:loading.remove class="bi bi-play-circle me-2"></i>
                        <div wire:loading class="spinner-border spinner-border-sm me-2" role="status">
                            <span class="visually-hidden">Loading...</span>
                        </div>
                        <span wire:loading.remove>Process Invoice</span>
                        <span wire:loading>Processing...</span>
                    </button>
                </div>
            </form>
        </div>
    </div>



                @if(!empty($shipments))
                    <div class="card mb-5">
                        <div class="card-body p-4">
                            <div class="d-flex justify-content-between align-items-center mb-4">
                                <div>
                                    <h2 class="h3 fw-bold text-dark mb-1">
                                        <i class="bi bi-table me-2 text-primary"></i>Invoice Data
                                    </h2>
                                    <p class="text-muted mb-0">Successfully extracted {{ count($shipments) }} shipment records</p>
                                </div>
                                <div class="d-flex align-items-center gap-3">
                                    <div class="bg-success bg-opacity-10 rounded-pill px-3 py-2">
                                        <i class="bi bi-check-circle-fill text-success me-2"></i>
                                        <span class="text-success fw-semibold">{{ count($shipments) }} items</span>
                                    </div>
                                    <button wire:click="$refresh" class="btn btn-outline-primary btn-sm">
                                        <i class="bi bi-arrow-clockwise me-2"></i>Refresh
                                    </button>
                                </div>
                            </div>
                        <div class="table-responsive">
                            <table class="table table-sm table-striped table-bordered w-100" style="table-layout: fixed; width: 100%;">
<colgroup>
	<col style="width:3%">
	<col style="width:12%">
	<col style="width:7%">
	<col style="width:7%">
	<col style="width:15%">
	<col style="width:18%">
	<col style="width:18%">
	<col style="width:6%">
	<col style="width:5%">
	<col style="width:5%">
	<col style="width:4%">
</colgroup>
<thead class="table-light">
	<tr>
		<th scope="col">#</th>
		<th scope="col">Parcel</th>
		<th scope="col">Courier</th>
		<th scope="col">Dept</th>
		<th scope="col">Reference</th>
		<th scope="col">Sent From</th>
		<th scope="col">Destination</th>
		<th scope="col">Weight</th>
		<th scope="col">Parcels</th>
		<th scope="col">VAT (£)</th>
		<th scope="col">Total (£)</th>
	</tr>
</thead>
                            <tbody>
                                @foreach($shipments as $idx => $s)
                                    <tr>
                                        <td class="text-center">{{ $idx + 1 }}</td>
                                        <td class="font-monospace small">{{ $s['parcel_number'] ?? '' }}</td>
                                        <td>{{ $s['courier'] ?? '' }}</td>
                                        <td>
                                            <input type="text" class="form-control form-control-sm" style="width: 80px;" wire:model.defer="shipments.{{ $idx }}.department">
                                        </td>
                                        <td class="text-truncate" style="max-width: 160px;" title="{{ $s['reference'] ?? '' }}">{{ $s['reference'] ?? '' }}</td>
                                        <td style="max-width: 220px; word-break: break-word;">
                                            <div class="fw-semibold">{{ $s['sent_from_name'] ?? '' }}</div>
                                            @php($fromLines = array_filter(array_map('trim', explode(',', $s['sent_from_address'] ?? ''))))
                                            <ul class="list-unstyled mb-0 small text-muted">
                                                @foreach($fromLines as $line)
                                                    <li>{{ $line }}</li>
                                                @endforeach
                                            </ul>
                                        </td>
                                        <td style="max-width: 220px; word-break: break-word;">
                                            <div class="fw-semibold">{{ $s['destination_name'] ?? '' }}</div>
                                            @php($destLines = array_filter(array_map('trim', explode(',', $s['destination_address'] ?? ''))))
                                            <ul class="list-unstyled mb-0 small text-muted">
                                                @foreach($destLines as $line)
                                                    <li>{{ $line }}</li>
                                                @endforeach
                                            </ul>
                                        </td>
                                        <td class="text-center">{{ $s['weight'] ?? '' }}</td>
                                        <td class="text-center">{{ $s['no_parcels'] ?? '' }}</td>
                                        <td class="text-end">{{ number_format((float)($s['vat_amount'] ?? 0), 2) }}</td>
                                        <td class="text-end">{{ number_format((float)($s['total'] ?? 0), 2) }}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                            <tfoot class="table-light">
                                <tr>
                                    <td colspan="9" class="text-end fw-semibold">Grand VAT</td>
                                    <td class="text-end fw-bold">{{ number_format($grandVat, 2) }}</td>
                                </tr>
                                <tr>
                                    <td colspan="9" class="text-end fw-semibold">Grand Total</td>
                                    <td class="text-end fw-bold">{{ number_format($grandTotal, 2) }}</td>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                    
                    <!-- Summary Section -->
                    <div class="row g-4 mb-5">
                        <div class="col-md-4">
                            <div class="stats-card">
                                <div class="bg-primary bg-opacity-10 rounded-circle d-inline-flex align-items-center justify-content-center mb-3" style="width: 60px; height: 60px;">
                                    <i class="bi bi-box-seam text-primary" style="font-size: 1.5rem;"></i>
                                </div>
                                <div class="stats-number">{{ count($shipments) }}</div>
                                <div class="stats-label">Total Shipments</div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="stats-card">
                                <div class="bg-success bg-opacity-10 rounded-circle d-inline-flex align-items-center justify-content-center mb-3" style="width: 60px; height: 60px;">
                                    <i class="bi bi-currency-pound text-success" style="font-size: 1.5rem;"></i>
                                </div>
                                <div class="stats-number">£{{ number_format($grandTotal, 2) }}</div>
                                <div class="stats-label">Grand Total</div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="stats-card">
                                <div class="bg-warning bg-opacity-10 rounded-circle d-inline-flex align-items-center justify-content-center mb-3" style="width: 60px; height: 60px;">
                                    <i class="bi bi-receipt text-warning" style="font-size: 1.5rem;"></i>
                                </div>
                                <div class="stats-number">£{{ number_format($grandVat, 2) }}</div>
                                <div class="stats-label">Total VAT</div>
                            </div>
                        </div>
                    </div>
                @endif
                
            </div>
        </div>
    </div>
</div>
