<div>
    <div class="container-fluid px-3 px-md-4 py-2">
        <div class="d-flex flex-wrap align-items-center justify-content-between gap-2">
            <div>
                <h1 class="h4 mb-0">Invoice Processing</h1>
                <small class="text-muted">Upload a PDF to extract shipment data</small>
            </div>
            <form wire:submit="processInvoice" class="d-flex align-items-center gap-2">
                <input type="file" id="pdfFile" wire:model="pdfFile" accept=".pdf" class="form-control form-control-sm" />
                <button type="submit" class="btn btn-primary btn-sm" wire:loading.attr="disabled">
                    <span wire:loading.remove>Process</span>
                    <span wire:loading class="spinner-border spinner-border-sm" role="status"></span>
                </button>
            </form>
        </div>
        @error('pdfFile')
            <div class="text-danger small mt-1">{{ $message }}</div>
        @enderror
    </div>
    
    
    
                @if(!empty($shipments))
                    <div class="card mb-5">
                        <div class="card-body p-4">
                            <div class="d-flex justify-content-between align-items-center mb-4">
                                <div>
                                    <h2 class="h3 fw-bold text-dark mb-1">
                                        <i class="bi bi-table me-2 text-primary"></i>Invoice Data
                                    </h2>
                                    <p class="text-muted mb-0">Successfully extracted {{ count($shipments) }} shipment records</p>
                                </div>
                                <div class="d-flex align-items-center gap-3">
                                    <div class="bg-success bg-opacity-10 rounded-pill px-3 py-2">
                                        <i class="bi bi-check-circle-fill text-success me-2"></i>
                                        <span class="text-success fw-semibold">{{ count($shipments) }} items</span>
                                    </div>
                                    <button wire:click="$refresh" class="btn btn-outline-primary btn-sm">
                                        <i class="bi bi-arrow-clockwise me-2"></i>Refresh
                                    </button>
                                </div>
                            </div>
                    <div class="table-responsive">
                            <table class="table table-sm table-hover table-bordered jen-table" style="table-layout: fixed; width: 100%;">
<colgroup>
	<col style="width:3%">
	<col style="width:12%">
	<col style="width:7%">
	<col style="width:7%">
	<col style="width:15%">
	<col style="width:18%">
	<col style="width:18%">
	<col style="width:6%">
	<col style="width:5%">
	<col style="width:5%">
	<col style="width:4%">
</colgroup>
<thead class="table-light">
	<tr>
		<th scope="col">#</th>
		<th scope="col">Parcel</th>
		<th scope="col">Courier</th>
		<th scope="col">Department</th>
		<th scope="col">Reference</th>
		<th scope="col">Sent From</th>
		<th scope="col">Destination</th>
		<th scope="col">Weight (kg)</th>
		<th scope="col">Parcels</th>
		<th scope="col">VAT (£)</th>
		<th scope="col">Total (£)</th>
	</tr>
</thead>
                            <tbody>
                                @foreach($shipments as $idx => $s)
                                    <tr>
                                        <td class="text-center">{{ $idx + 1 }}</td>
                                        <td class="font-monospace">{{ $s['parcel_number'] ?? '' }}</td>
                                        <td>{{ $s['courier'] ?? '' }}</td>
                                        <td>
                                            <input type="text" class="form-control form-control-sm jen-pill text-center" style="width: 80px;" wire:model.defer="shipments.{{ $idx }}.department">
                                        </td>
                                        <td class="ref-cell" style="white-space: pre-line;">{{ $s['reference'] ?? '' }}</td>
                                        <td class="address-cell">
                                            <div class="fw-semibold">{{ $s['sent_from_name'] ?? '' }}</div>
                                            @php
                                                $fromLines = array_filter(
                                                    array_map('trim', preg_split("/\r?\n/", $s['sent_from_address'] ?? ''))
                                                );
                                            @endphp
                                            <ul class="list-unstyled mb-0 small text-muted">
                                                @foreach($fromLines as $line)
                                                    <li>{{ $line }}</li>
                                                @endforeach
                                            </ul>
                                        </td>
                                        <td class="address-cell">
                                            <div class="fw-semibold">{{ $s['destination_name'] ?? '' }}</div>
                                            @php
                                                $destLines = array_filter(
                                                    array_map('trim', preg_split("/\r?\n/", $s['destination_address'] ?? ''))
                                                );
                                            @endphp
                                            <ul class="list-unstyled mb-0 small text-muted">
                                                @foreach($destLines as $line)
                                                    <li>{{ $line }}</li>
                                                @endforeach
                                            </ul>
                                        </td>
                                        <td class="text-center">{{ $s['weight'] ?? '' }}</td>
                                        <td class="text-center">{{ $s['no_parcels'] ?? '' }}</td>
                                        <td class="text-end">{{ number_format((float)($s['vat_amount'] ?? 0), 2) }}</td>
                                        <td class="text-end">{{ number_format((float)($s['total'] ?? 0), 2) }}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                            <tfoot class="table-light">
                                <tr>
                                    <td colspan="9" class="text-end fw-semibold">Grand VAT</td>
                                    <td class="text-end fw-bold">{{ number_format($grandVat, 2) }}</td>
                                </tr>
                                <tr>
                                    <td colspan="9" class="text-end fw-semibold">Grand Total</td>
                                    <td class="text-end fw-bold">{{ number_format($grandTotal, 2) }}</td>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                    
                    <!-- Summary Section -->
                    <div class="row g-4 mb-5">
                        <div class="col-md-4">
                            <div class="stats-card">
                                <div class="bg-primary bg-opacity-10 rounded-circle d-inline-flex align-items-center justify-content-center mb-3" style="width: 60px; height: 60px;">
                                    <i class="bi bi-box-seam text-primary" style="font-size: 1.5rem;"></i>
                                </div>
                                <div class="stats-number">{{ count($shipments) }}</div>
                                <div class="stats-label">Total Shipments</div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="stats-card">
                                <div class="bg-success bg-opacity-10 rounded-circle d-inline-flex align-items-center justify-content-center mb-3" style="width: 60px; height: 60px;">
                                    <i class="bi bi-currency-pound text-success" style="font-size: 1.5rem;"></i>
                                </div>
                                <div class="stats-number">£{{ number_format($grandTotal, 2) }}</div>
                                <div class="stats-label">Grand Total</div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="stats-card">
                                <div class="bg-warning bg-opacity-10 rounded-circle d-inline-flex align-items-center justify-content-center mb-3" style="width: 60px; height: 60px;">
                                    <i class="bi bi-receipt text-warning" style="font-size: 1.5rem;"></i>
                                </div>
                                <div class="stats-number">£{{ number_format($grandVat, 2) }}</div>
                                <div class="stats-label">Total VAT</div>
                            </div>
                        </div>
                    </div>
                @endif
                
            </div>
        </div>
    </div>

    @if(!empty($shipments))
        @php
            $deptSummary = [];
            foreach ($shipments as $s) {
                $dept = strtoupper(trim($s['department'] ?? '')) ?: 'UNKNOWN';
                $rate = ((float)($s['vat_amount'] ?? 0)) > 0 ? 20 : 0;
                $key = $dept.'|'.$rate;
                $deptSummary[$key] = (
                    ($deptSummary[$key] ?? 0)
                ) + (float)($s['total'] ?? 0);
            }
            ksort($deptSummary);
        @endphp
        <div class="container-fluid px-3 px-md-4 pb-4">
            <div class="card">
                <div class="card-body p-3">
                    <h3 class="h6 mb-3">Department Totals (Dept, VAT, Total)</h3>
                    <div class="table-responsive">
                        <table class="table table-sm align-middle mb-0">
                            <thead class="table-light">
                                <tr>
                                    <th style="width:20%">Dept</th>
                                    <th style="width:15%">VAT</th>
                                    <th class="text-end" style="width:20%">Total (£)</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($deptSummary as $k => $sum)
                                    @php([$dept,$rate] = explode('|', $k))
                                    <tr>
                                        <td>{{ $dept }}</td>
                                        <td>{{ $rate }}</td>
                                        <td class="text-end">{{ number_format((float)$sum, 2) }}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    @endif
</div>
