<div class="hero-section">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-8">
                <h1 class="hero-title">Invoice Processing</h1>
                <p class="hero-subtitle">Streamline your financial workflow with intelligent PDF invoice extraction</p>
            </div>
            <div class="col-lg-4 text-center">
                <div class="bg-white bg-opacity-20 rounded-circle d-inline-flex align-items-center justify-content-center" style="width: 120px; height: 120px;">
                    <i class="bi bi-receipt-cutoff text-white" style="font-size: 3rem;"></i>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="container">
    <!-- File Upload Section -->
    <div class="card mb-5">
        <div class="card-body p-5">
            <div class="text-center mb-4">
                <div class="bg-primary bg-opacity-10 rounded-circle d-inline-flex align-items-center justify-content-center mb-3" style="width: 80px; height: 80px;">
                    <i class="bi bi-cloud-upload text-primary" style="font-size: 2rem;"></i>
                </div>
                <h2 class="h3 fw-bold text-dark mb-2">Upload Your Invoice</h2>
                <p class="text-muted">Simply drag and drop or select your PDF invoice to get started</p>
            </div>
            
            <form wire:submit="processInvoice">
                <div class="mb-4">
                    <label for="pdfFile" class="form-label fw-semibold text-dark">
                        <i class="bi bi-file-earmark-pdf me-2 text-danger"></i>Select PDF Invoice
                    </label>
                    <input 
                        type="file" 
                        id="pdfFile" 
                        wire:model="pdfFile"
                        accept=".pdf"
                        class="form-control form-control-lg"
                    />
                    @error('pdfFile') 
                        <div class="alert alert-danger mt-3 d-flex align-items-center border-0" role="alert" style="border-radius: 12px;">
                            <i class="bi bi-exclamation-triangle-fill me-2"></i>
                            {{ $message }}
                        </div>
                    @enderror
                </div>

                <div class="text-center">
                    <button 
                        type="submit" 
                        class="btn btn-primary btn-lg px-5 py-3 fw-semibold"
                        wire:loading.attr="disabled"
                    >
                        <i wire:loading.remove class="bi bi-play-circle me-2"></i>
                        <div wire:loading class="spinner-border spinner-border-sm me-2" role="status">
                            <span class="visually-hidden">Loading...</span>
                        </div>
                        <span wire:loading.remove>Process Invoice</span>
                        <span wire:loading>Processing...</span>
                    </button>
                </div>
            </form>
        </div>
    </div>



                @if(!empty($shipments))
                    <div class="mb-4">
                        <div class="d-flex justify-content-between align-items-center mb-3">
                            <h2 class="h4 fw-semibold text-dark mb-0">Shipment Data</h2>
                            <div class="d-flex align-items-center gap-3">
                                <span class="text-muted small">{{ count($shipments) }} shipments found</span>
                                <button wire:click="$refresh" class="btn btn-outline-secondary btn-sm">
                                    <svg class="bi me-2" width="16" height="16" fill="currentColor" viewBox="0 0 16 16">
                                        <path d="M8 3a5 5 0 1 1-4.546 2.914.5.5 0 0 0-.908-.417A6 6 0 1 0 8 2v1z"/>
                                        <path d="M8 4.466V.534a.25.25 0 0 0-.41-.192L5.23 2.308a.25.25 0 0 0 0 .384l2.36 1.966A.25.25 0 0 0 8 4.466z"/>
                                    </svg>
                                    Refresh
                                </button>
                            </div>
                        </div>
                        <div class="table-responsive">
                            <table class="table table-sm table-striped table-bordered">
                            <thead class="table-light">
                                <tr>
                                    <th scope="col" style="width: 40px;">#</th>
                                    <th scope="col" style="width: 120px;">Parcel</th>
                                    <th scope="col" style="width: 80px;">Courier</th>
                                    <th scope="col" style="width: 100px;">Dept</th>
                                    <th scope="col" style="width: 160px;">Reference</th>
                                    <th scope="col" style="width: 200px;">Sent From</th>
                                    <th scope="col" style="width: 200px;">Destination</th>
                                    <th scope="col" style="width: 80px;">Weight</th>
                                    <th scope="col" style="width: 80px;">Parcels</th>
                                    <th scope="col" style="width: 100px;">VAT (£)</th>
                                    <th scope="col" style="width: 100px;">Total (£)</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($shipments as $idx => $s)
                                    <tr>
                                        <td class="text-center">{{ $idx + 1 }}</td>
                                        <td class="font-monospace small">{{ $s['parcel_number'] ?? '' }}</td>
                                        <td>{{ $s['courier'] ?? '' }}</td>
                                        <td>
                                            <input type="text" class="form-control form-control-sm" style="width: 80px;" wire:model.defer="shipments.{{ $idx }}.department">
                                        </td>
                                        <td class="text-truncate" style="max-width: 160px;" title="{{ $s['reference'] ?? '' }}">{{ $s['reference'] ?? '' }}</td>
                                        <td>
                                            <div class="fw-semibold text-truncate">{{ $s['sent_from_name'] ?? '' }}</div>
                                            <div class="small text-muted text-truncate">{{ $s['sent_from_address'] ?? '' }}</div>
                                        </td>
                                        <td>
                                            <div class="fw-semibold text-truncate">{{ $s['destination_name'] ?? '' }}</div>
                                            <div class="small text-muted text-truncate">{{ $s['destination_address'] ?? '' }}</div>
                                        </td>
                                        <td class="text-center">{{ $s['weight'] ?? '' }}</td>
                                        <td class="text-center">{{ $s['no_parcels'] ?? '' }}</td>
                                        <td class="text-end">{{ number_format((float)($s['vat_amount'] ?? 0), 2) }}</td>
                                        <td class="text-end">{{ number_format((float)($s['total'] ?? 0), 2) }}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                            <tfoot class="table-light">
                                <tr>
                                    <td colspan="9" class="text-end fw-semibold">Grand VAT</td>
                                    <td class="text-end fw-bold">{{ number_format($grandVat, 2) }}</td>
                                </tr>
                                <tr>
                                    <td colspan="9" class="text-end fw-semibold">Grand Total</td>
                                    <td class="text-end fw-bold">{{ number_format($grandTotal, 2) }}</td>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                    
                    <!-- Summary Section -->
                    <div class="card bg-primary text-white">
                        <div class="card-body">
                            <div class="row text-center">
                                <div class="col-md-4">
                                    <div class="h3 fw-bold">{{ count($shipments) }}</div>
                                    <div class="small opacity-75">Total Shipments</div>
                                </div>
                                <div class="col-md-4">
                                    <div class="h3 fw-bold">£{{ number_format($grandTotal, 2) }}</div>
                                    <div class="small opacity-75">Grand Total</div>
                                </div>
                                <div class="col-md-4">
                                    <div class="h3 fw-bold">£{{ number_format($grandVat, 2) }}</div>
                                    <div class="small opacity-75">Total VAT</div>
                                </div>
                            </div>
                        </div>
                    </div>
                @endif
            </div>
        </div>
    </div>
</div>
