<div class="py-4">
    <div class="container">
        <div class="card shadow-sm">
            <div class="card-body p-4">
                <div class="mb-4">
                    <h1 class="display-6 fw-bold text-dark mb-2">Process Inxpress Invoice</h1>
                    <p class="text-muted">Upload and process PDF invoices to extract shipment data</p>
                </div>
                
                <!-- File Upload Section -->
                <div class="card bg-light border-0 mb-4">
                    <div class="card-body">
                        <form wire:submit="processInvoice">
                            <div class="mb-3">
                                <label for="pdfFile" class="form-label fw-semibold">
                                    Select PDF Invoice
                                </label>
                                <input 
                                    type="file" 
                                    id="pdfFile" 
                                    wire:model="pdfFile"
                                    accept=".pdf"
                                    class="form-control"
                                />
                                @error('pdfFile') 
                                    <div class="alert alert-danger mt-2 d-flex align-items-center" role="alert">
                                        <svg class="bi flex-shrink-0 me-2" width="16" height="16" fill="currentColor" viewBox="0 0 16 16">
                                            <path d="M8 15A7 7 0 1 1 8 1a7 7 0 0 1 0 14zm0 1A8 8 0 1 0 8 0a8 8 0 0 0 0 16z"/>
                                            <path d="M7.002 11a1 1 0 1 1 2 0 1 1 0 0 1-2 0zM7.1 4.995a.905.905 0 1 1 1.8 0l-.35 3.507a.552.552 0 0 1-1.1 0L7.1 4.995z"/>
                                        </svg>
                                        {{ $message }}
                                    </div>
                                @enderror
                            </div>

                            <div class="text-center pt-3">
                                <button 
                                    type="submit" 
                                    class="btn btn-primary btn-lg px-5 py-3 fw-semibold"
                                    wire:loading.attr="disabled"
                                >
                                    <svg wire:loading.remove class="bi me-2" width="20" height="20" fill="currentColor" viewBox="0 0 16 16">
                                        <path d="M10.97 4.97a.235.235 0 0 0-.02.022L7.477 9.417a.248.248 0 0 0 .234.41l4.25-.667a.25.25 0 0 0 .234-.41L10.97 4.97z"/>
                                        <path d="M8 15A7 7 0 1 1 8 1a7 7 0 0 1 0 14zm0 1A8 8 0 1 0 8 0a8 8 0 0 0 0 16z"/>
                                    </svg>
                                    <svg wire:loading class="bi me-2 spinner-border spinner-border-sm" width="20" height="20" fill="currentColor" viewBox="0 0 16 16">
                                        <path d="M8 3a5 5 0 1 1-4.546 2.914.5.5 0 0 0-.908-.417A6 6 0 1 0 8 2v1z"/>
                                        <path d="M8 4.466V.534a.25.25 0 0 0-.41-.192L5.23 2.308a.25.25 0 0 0 0 .384l2.36 1.966A.25.25 0 0 0 8 4.466z"/>
                                    </svg>
                                    <span wire:loading.remove>Process Invoice</span>
                                    <span wire:loading>Processing...</span>
                                </button>
                            </div>
                        </form>
                    </div>
                </div>



                @if(!empty($shipments))
                    <div class="mb-4">
                        <div class="d-flex justify-content-between align-items-center mb-3">
                            <h2 class="h4 fw-semibold text-dark mb-0">Shipment Data</h2>
                            <div class="d-flex align-items-center gap-3">
                                <span class="text-muted small">{{ count($shipments) }} shipments found</span>
                                <button wire:click="$refresh" class="btn btn-outline-secondary btn-sm">
                                    <svg class="bi me-2" width="16" height="16" fill="currentColor" viewBox="0 0 16 16">
                                        <path d="M8 3a5 5 0 1 1-4.546 2.914.5.5 0 0 0-.908-.417A6 6 0 1 0 8 2v1z"/>
                                        <path d="M8 4.466V.534a.25.25 0 0 0-.41-.192L5.23 2.308a.25.25 0 0 0 0 .384l2.36 1.966A.25.25 0 0 0 8 4.466z"/>
                                    </svg>
                                    Refresh
                                </button>
                            </div>
                        </div>
                        <div class="table-responsive">
                            <table class="table table-sm table-striped table-bordered">
                            <thead class="table-light">
                                <tr>
                                    <th scope="col" style="width: 40px;">#</th>
                                    <th scope="col" style="width: 120px;">Parcel</th>
                                    <th scope="col" style="width: 80px;">Courier</th>
                                    <th scope="col" style="width: 100px;">Dept</th>
                                    <th scope="col" style="width: 160px;">Reference</th>
                                    <th scope="col" style="width: 200px;">Sent From</th>
                                    <th scope="col" style="width: 200px;">Destination</th>
                                    <th scope="col" style="width: 80px;">Weight</th>
                                    <th scope="col" style="width: 80px;">Parcels</th>
                                    <th scope="col" style="width: 100px;">VAT (£)</th>
                                    <th scope="col" style="width: 100px;">Total (£)</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($shipments as $idx => $s)
                                    <tr>
                                        <td class="text-center">{{ $idx + 1 }}</td>
                                        <td class="font-monospace small">{{ $s['parcel_number'] ?? '' }}</td>
                                        <td>{{ $s['courier'] ?? '' }}</td>
                                        <td>
                                            <input type="text" class="form-control form-control-sm" style="width: 80px;" wire:model.defer="shipments.{{ $idx }}.department">
                                        </td>
                                        <td class="text-truncate" style="max-width: 160px;" title="{{ $s['reference'] ?? '' }}">{{ $s['reference'] ?? '' }}</td>
                                        <td>
                                            <div class="fw-semibold text-truncate">{{ $s['sent_from_name'] ?? '' }}</div>
                                            <div class="small text-muted text-truncate">{{ $s['sent_from_address'] ?? '' }}</div>
                                        </td>
                                        <td>
                                            <div class="fw-semibold text-truncate">{{ $s['destination_name'] ?? '' }}</div>
                                            <div class="small text-muted text-truncate">{{ $s['destination_address'] ?? '' }}</div>
                                        </td>
                                        <td class="text-center">{{ $s['weight'] ?? '' }}</td>
                                        <td class="text-center">{{ $s['no_parcels'] ?? '' }}</td>
                                        <td class="text-end">{{ number_format((float)($s['vat_amount'] ?? 0), 2) }}</td>
                                        <td class="text-end">{{ number_format((float)($s['total'] ?? 0), 2) }}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                            <tfoot class="table-light">
                                <tr>
                                    <td colspan="9" class="text-end fw-semibold">Grand VAT</td>
                                    <td class="text-end fw-bold">{{ number_format($grandVat, 2) }}</td>
                                </tr>
                                <tr>
                                    <td colspan="9" class="text-end fw-semibold">Grand Total</td>
                                    <td class="text-end fw-bold">{{ number_format($grandTotal, 2) }}</td>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                    
                    <!-- Summary Section -->
                    <div class="bg-blue-50 border border-blue-200 rounded-lg p-4">
                        <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                            <div class="text-center">
                                <div class="text-2xl font-bold text-blue-900">{{ count($shipments) }}</div>
                                <div class="text-sm text-blue-700">Total Shipments</div>
                            </div>
                            <div class="text-center">
                                <div class="text-2xl font-bold text-green-900">£{{ number_format($grandTotal, 2) }}</div>
                                <div class="text-sm text-green-700">Grand Total</div>
                            </div>
                            <div class="text-center">
                                <div class="text-2xl font-bold text-purple-900">£{{ number_format($grandVat, 2) }}</div>
                                <div class="text-sm text-purple-700">Total VAT</div>
                            </div>
                        </div>
                    </div>
                @endif
            </div>
        </div>
    </div>
</div>
