<?php

namespace App\Livewire;

use Livewire\Component;
use App\Models\Item;
use App\Models\Colourway;
use Illuminate\Support\Facades\Cookie;

class AddToBasket extends Component
{
    public $itemId;
    public $colourwayId = null;
    public $quantity = 1;
    public $colourways = [];
    public $added = false;

    public function mount($itemId, $colourways = [])
    {
        $this->itemId = $itemId;
        $this->colourways = $colourways;
        
        // Auto-select first colourway if available
        if (count($colourways) > 0) {
            $this->colourwayId = $colourways[0]->id;
        }
    }

    public function addToBasket()
    {
        $this->validate([
            'quantity' => 'required|integer|min:1',
        ]);

        // Get existing basket
        $basketCookie = Cookie::get('basket', '[]');
        $basket = json_decode($basketCookie, true);

        // Check if item already exists in basket
        $found = false;
        foreach ($basket as &$item) {
            if ($item['item_id'] == $this->itemId && $item['colourway_id'] == $this->colourwayId) {
                $item['quantity'] += $this->quantity;
                $found = true;
                break;
            }
        }

        // If not found, add new item
        if (!$found) {
            $basket[] = [
                'item_id' => $this->itemId,
                'colourway_id' => $this->colourwayId,
                'quantity' => $this->quantity,
            ];
        }

        // Save basket
        Cookie::queue('basket', json_encode($basket), 60 * 24 * 30); // 30 days

        // Show success message
        $this->added = true;
        $this->dispatch('basket-updated');

        // Reset after 3 seconds
        $this->dispatch('basket-added');
    }

    public function render()
    {
        return view('livewire.add-to-basket');
    }
}
