# Quick Stripe Setup Guide

## Step 1: Get Stripe Test API Keys

1. Go to https://dashboard.stripe.com/test/apikeys
2. Sign up or log in to Stripe
3. Make sure you're in **TEST MODE** (toggle in top right)
4. Copy your keys:
   - **Secret key** (starts with `sk_test_...`) - Click "Reveal test key"
   - **Publishable key** (starts with `pk_test_...`)

## Step 2: Create Product Prices in Stripe

1. Go to https://dashboard.stripe.com/test/products
2. Click **"+ Add product"** for each plan:

### Starter Plan
- **Name**: Starter Plan
- **Description**: 1,000 photos • 5GB storage • Subdomain
- **Pricing**:
  - Type: Recurring
  - Amount: £10.00
  - Billing period: Monthly
- Click **Save product**
- Copy the **Price ID** (starts with `price_...`)

### Professional Plan
- **Name**: Professional Plan
- **Description**: 10,000 photos • 50GB storage • Custom domain
- **Pricing**:
  - Type: Recurring
  - Amount: £25.00
  - Billing period: Monthly
- Click **Save product**
- Copy the **Price ID** (starts with `price_...`)

### Business Plan
- **Name**: Business Plan
- **Description**: 30,000 photos • 150GB storage • Multiple domains
- **Pricing**:
  - Type: Recurring
  - Amount: £75.00
  - Billing period: Monthly
- Click **Save product**
- Copy the **Price ID** (starts with `price_...`)

## Step 3: Add to Your .env File

Open `/Users/neilwiddowson/VybePhoto/.env` and add these lines:

```bash
# Stripe Test Keys
STRIPE_SECRET_KEY=sk_test_your_secret_key_here
STRIPE_PUBLISHABLE_KEY=pk_test_your_publishable_key_here

# Stripe Price IDs
STRIPE_PRICE_STARTER=price_starter_id_here
STRIPE_PRICE_PROFESSIONAL=price_professional_id_here
STRIPE_PRICE_BUSINESS=price_business_id_here
```

Replace the values with your actual keys and price IDs.

## Step 4: Restart the Server

Kill the current server (Ctrl+C) and restart:
```bash
npm start
```

## Step 5: Test Payment Flow

1. Go to http://app.localhost:3000/register?plan=professional
2. Fill out the form
3. Click "Continue to Payment"
4. You should be redirected to Stripe Checkout
5. Use test card: **4242 4242 4242 4242**
   - Expiry: Any future date
   - CVC: Any 3 digits
   - ZIP: Any 5 digits
6. Complete payment
7. You should be redirected back and logged in!

## Test Cards

- **Success**: 4242 4242 4242 4242
- **Declined**: 4000 0000 0000 0002
- **Requires authentication**: 4000 0025 0000 3155
- **Insufficient funds**: 4000 0000 0000 9995

## Troubleshooting

If you still see errors after adding keys:
1. Make sure there are no spaces in the keys
2. Make sure you're using TEST keys (not live keys)
3. Check the server logs for specific error messages
4. Restart the server after changing .env

## Quick Alternative: Skip Payment for Testing

If you just want to test the interface without setting up Stripe:
- Use the **Starter plan** which has a free trial (no payment required)
- This will let you test the full admin interface

