# Quick Stripe Setup Guide

## Step 1: Get Stripe Test API Keys

1. Go to https://dashboard.stripe.com/test/apikeys
2. Sign up or log in to Stripe
3. Make sure you're in **TEST MODE** (toggle in top right)
4. Copy your keys:
   - **Secret key** (starts with `sk_test_...`) - Click "Reveal test key"
   - **Publishable key** (starts with `pk_test_...`)

## Step 2: Create Product Prices in Stripe

1. Go to https://dashboard.stripe.com/test/products
2. Click **"+ Add product"** for each plan:

### Starter Plan
- **Name**: Starter Plan
- **Description**: 1,000 photos • 5GB storage • Subdomain
- **Pricing**:
  - Type: Recurring
  - Amount: £10.00
  - Billing period: Monthly
- Click **Save product**
- Copy the **Price ID** (starts with `price_...`)

### Professional Plan
- **Name**: Professional Plan
- **Description**: 10,000 photos • 50GB storage • Custom domain
- **Pricing**:
  - Type: Recurring
  - Amount: £25.00
  - Billing period: Monthly
- Click **Save product**
- Copy the **Price ID** (starts with `price_...`)

### Business Plan
- **Name**: Business Plan
- **Description**: 30,000 photos • 150GB storage • Multiple domains
- **Pricing**:
  - Type: Recurring
  - Amount: £75.00
  - Billing period: Monthly
- Click **Save product**
- Copy the **Price ID** (starts with `price_...`)

## Step 3: Add Stripe Secret Key to Your .env File

Open `/Users/neilwiddowson/VybePhoto/.env` and add these lines:

```bash
# Stripe Test Keys
STRIPE_SECRET_KEY=sk_test_your_secret_key_here
STRIPE_PUBLISHABLE_KEY=pk_test_your_publishable_key_here
```

**Note:** Price IDs are now stored in the database! You'll add them through the superuser interface in Step 5.

## Step 4: Run the Database Migration

Apply the new migration to create the subscription_tiers table:

```bash
psql $DB_NAME -f migrations/004-add-subscription-tiers-table.sql
```

Or if using connection string:
```bash
psql "postgresql://user:password@localhost:5432/dbname" -f migrations/004-add-subscription-tiers-table.sql
```

This creates the `subscription_tiers` table with default values.

## Step 5: Add Stripe Price IDs to Database

You have two options:

### Option A: Using SQL (Quick)

Run this SQL to add your Price IDs:

```sql
UPDATE subscription_tiers SET stripe_price_id = 'price_starter_id' WHERE tier_name = 'starter';
UPDATE subscription_tiers SET stripe_price_id = 'price_professional_id' WHERE tier_name = 'professional';
UPDATE subscription_tiers SET stripe_price_id = 'price_business_id' WHERE tier_name = 'business';
```

### Option B: Using Superuser Interface (Recommended)

1. Make sure you have a superuser account (see SUPERUSER-QUICKSTART.md)
2. Login as superuser
3. Go to http://app.localhost:3000/superuser/tiers
4. Edit each tier and add the Stripe Price ID
5. Save

## Step 6: Restart the Server

Kill the current server (Ctrl+C) and restart:
```bash
npm start
```

## Step 7: Test Payment Flow

1. Go to http://app.localhost:3000/register?plan=professional
2. Fill out the form
3. Click "Continue to Payment"
4. You should be redirected to Stripe Checkout
5. Use test card: **4242 4242 4242 4242**
   - Expiry: Any future date
   - CVC: Any 3 digits
   - ZIP: Any 5 digits
6. Complete payment
7. You should be redirected back and logged in!

## Test Cards

- **Success**: 4242 4242 4242 4242
- **Declined**: 4000 0000 0000 0002
- **Requires authentication**: 4000 0025 0000 3155
- **Insufficient funds**: 4000 0000 0000 9995

## Troubleshooting

If you still see errors after adding keys:
1. Make sure there are no spaces in the keys
2. Make sure you're using TEST keys (not live keys)
3. Check the server logs for specific error messages
4. Restart the server after changing .env

## Quick Alternative: Skip Payment for Testing

If you just want to test the interface without setting up Stripe:
- Use the **Starter plan** which has a free trial (no payment required)
- This will let you test the full admin interface

