<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('customer_order_line_quantities', function (Blueprint $table) {
            // Remove old price cache columns that are now replaced by the price_resolutions table
            $table->dropColumn([
                'quote_cache',
                'cmt_cache', 
                'cost_cache',
                'quote_status_cache',
                'cmt_status_cache',
                'transport_budget_cache',
            ]);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('customer_order_line_quantities', function (Blueprint $table) {
            // Re-add the old cache columns if needed for rollback
            $table->decimal('quote_cache', 10, 2)->nullable();
            $table->decimal('cmt_cache', 10, 2)->nullable();
            $table->decimal('cost_cache', 10, 2)->nullable();
            $table->string('quote_status_cache')->nullable();
            $table->string('cmt_status_cache')->nullable();
            $table->decimal('transport_budget_cache', 10, 2)->nullable();
        });
    }
};