<div>
<div class="py-4" style="background-color: var(--ys-bg-section);">
    <div class="container">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb ys-breadcrumb">
                <li class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></li>
                <li class="breadcrumb-item active">Shop All</li>
            </ol>
        </nav>
        
        <h1 class="fw-bold mb-0">All Products</h1>
    </div>
</div>

<div class="container py-5">
    <div class="row">
        <!-- Filters Sidebar -->
        <div class="col-lg-3 mb-4 mb-lg-0">
            <div class="ys-card p-4 sticky-top" style="top: 100px;">
                <div class="d-flex justify-content-between align-items-center mb-3">
                    <h5 class="fw-bold mb-0">Filters</h5>
                    @if($selectedSeason || $selectedCategory || $search)
                        <button wire:click="clearFilters" class="btn btn-sm btn-outline-secondary">
                            Clear All
                        </button>
                    @endif
                </div>

                <!-- Search -->
                <div class="mb-4">
                    <label class="form-label fw-semibold">Search</label>
                    <input type="text" 
                           wire:model.live.debounce.300ms="search" 
                           class="form-control" 
                           placeholder="Search products...">
                </div>

                <!-- Season Filter -->
                <div class="mb-4">
                    <label class="form-label fw-semibold">Season</label>
                    <select wire:model.live="selectedSeason" class="form-select">
                        <option value="">All Seasons</option>
                        @foreach($seasons as $season)
                            <option value="{{ $season->slug }}">{{ $season->name }}</option>
                        @endforeach
                    </select>
                </div>

                <!-- Category Filter -->
                <div class="mb-4">
                    <label class="form-label fw-semibold">Category</label>
                    <select wire:model.live="selectedCategory" class="form-select">
                        <option value="">All Categories</option>
                        @foreach($categories as $category)
                            <option value="{{ $category->slug }}">{{ $category->name }}</option>
                        @endforeach
                    </select>
                </div>

                <!-- Sort By -->
                <div>
                    <label class="form-label fw-semibold">Sort By</label>
                    <select wire:model.live="sortBy" class="form-select">
                        <option value="latest">Latest</option>
                        <option value="name">Name (A-Z)</option>
                        <option value="price_asc">Price (Low to High)</option>
                        <option value="price_desc">Price (High to Low)</option>
                    </select>
                </div>
            </div>
        </div>

        <!-- Products Grid -->
        <div class="col-lg-9">
            <div class="mb-4">
                <p class="text-muted">
                    Showing {{ $products->firstItem() ?? 0 }} - {{ $products->lastItem() ?? 0 }} of {{ $products->total() }} products
                </p>
            </div>

            @if($products->count() > 0)
                <div class="product-grid mb-4">
                    @foreach($products as $product)
                        <div class="product-card" wire:key="product-{{ $product->id }}">
                            <a href="{{ route('product.show', $product->slug) }}" class="text-decoration-none">
                                @php
                                    $productImage = $product->primary_image;
                                    if (!$productImage && $product->colourways && $product->colourways->count() > 0) {
                                        $colourwayWithImage = $product->colourways->firstWhere('image', '!=', null);
                                        if ($colourwayWithImage) {
                                            $productImage = $colourwayWithImage->image;
                                        }
                                    }
                                @endphp
                                @if($productImage)
                                    <img src="{{ Storage::url($productImage) }}" 
                                         alt="{{ $product->name }}"
                                         loading="lazy">
                                @else
                                    <div class="placeholder-box" 
                                         style="height: 300px;">
                                        <span>No Image</span>
                                    </div>
                                @endif
                                
                                <div class="p-3">
                                    <div class="d-flex gap-2 mb-2">
                                        @if($product->season)
                                            <span class="badge badge-ys-primary small">{{ $product->season->name }}</span>
                                        @endif
                                        @if($product->category)
                                            <span class="badge badge-ys-accent small">{{ $product->category->name }}</span>
                                        @endif
                                    </div>
                                    
                                    <h5 class="fw-bold mb-2" style="color: var(--ys-text-primary);">
                                        {{ $product->name }}
                                    </h5>
                                    
                                    @if($product->short_description)
                                        <p class="text-muted small mb-2">
                                            {{ Str::limit($product->short_description, 60) }}
                                        </p>
                                    @endif
                                    
                                    <div class="d-flex justify-content-between align-items-center">
                                        <span class="fw-bold h5 mb-0" style="color: var(--ys-primary);">
                                            {{ $product->formatted_price }}
                                        </span>
                                        <span class="btn btn-sm btn-ys-primary">View Details</span>
                                    </div>
                                </div>
                            </a>
                        </div>
                    @endforeach
                </div>

                <!-- Pagination -->
                <div class="d-flex justify-content-center">
                    {{ $products->links() }}
                </div>
            @else
                <div class="text-center py-5">
                    <svg xmlns="http://www.w3.org/2000/svg" width="64" height="64" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="mb-3" style="color: var(--ys-gray);">
                        <circle cx="11" cy="11" r="8"></circle>
                        <path d="m21 21-4.35-4.35"></path>
                    </svg>
                    <h4 class="fw-bold mb-2">No products found</h4>
                    <p class="text-muted mb-3">Try adjusting your filters or search terms</p>
                    <button wire:click="clearFilters" class="btn btn-ys-primary">
                        Clear Filters
                    </button>
                </div>
            @endif
        </div>
    </div>
</div>
</div>

