<div>
    <!-- Flash Messages -->
    @if (session()->has('message'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <i class="bi bi-check-circle me-2"></i>{{ session('message') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    @if (session()->has('error'))
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <i class="bi bi-exclamation-triangle me-2"></i>{{ session('error') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <!-- Header -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h1 class="h3 mb-1">Orders</h1>
            <p class="text-muted mb-0">Manage customer orders and track fulfillment</p>
        </div>
        <button class="btn btn-primary">
            <i class="bi bi-plus-lg me-2"></i>Create Order
        </button>
    </div>

    <!-- Stats Cards -->
    <div class="row g-3 mb-4">
        <div class="col-md-3">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-start">
                        <div>
                            <p class="text-muted mb-1 small">Total Orders</p>
                            <h3 class="mb-0">{{ number_format($totalOrders) }}</h3>
                        </div>
                        <div class="bg-primary bg-opacity-10 rounded p-2">
                            <i class="bi bi-cart-check text-primary fs-4"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-start">
                        <div>
                            <p class="text-muted mb-1 small">Total Revenue</p>
                            <h3 class="mb-0">£{{ number_format($totalRevenue, 2) }}</h3>
                        </div>
                        <div class="bg-success bg-opacity-10 rounded p-2">
                            <i class="bi bi-currency-pound text-success fs-4"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-start">
                        <div>
                            <p class="text-muted mb-1 small">Pending Orders</p>
                            <h3 class="mb-0">{{ number_format($pendingOrders) }}</h3>
                        </div>
                        <div class="bg-warning bg-opacity-10 rounded p-2">
                            <i class="bi bi-hourglass-split text-warning fs-4"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-start">
                        <div>
                            <p class="text-muted mb-1 small">Processing</p>
                            <h3 class="mb-0">{{ number_format($processingOrders) }}</h3>
                        </div>
                        <div class="bg-info bg-opacity-10 rounded p-2">
                            <i class="bi bi-arrow-repeat text-info fs-4"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Filters -->
    <div class="card mb-4">
        <div class="card-body">
            <div class="row g-3">
                <div class="col-md-3">
                    <label class="form-label">Search</label>
                    <div class="input-group">
                        <span class="input-group-text">
                            <i class="bi bi-search"></i>
                        </span>
                        <input type="text" 
                               wire:model.live.debounce.300ms="search" 
                               class="form-control" 
                               placeholder="Order #, customer, invoice...">
                    </div>
                </div>
                
                <div class="col-md-2">
                    <label class="form-label">Status</label>
                    <select wire:model.live="statusFilter" class="form-select">
                        <option value="">All Statuses</option>
                        <option value="pending">Pending</option>
                        <option value="confirmed">Confirmed</option>
                        <option value="processing">Processing</option>
                        <option value="shipped">Shipped</option>
                        <option value="delivered">Delivered</option>
                        <option value="cancelled">Cancelled</option>
                    </select>
                </div>
                
                <div class="col-md-2">
                    <label class="form-label">Date Range</label>
                    <select wire:model.live="dateFilter" class="form-select">
                        <option value="">All Time</option>
                        <option value="today">Today</option>
                        <option value="week">This Week</option>
                        <option value="month">This Month</option>
                        <option value="year">This Year</option>
                        <option value="last_30_days">Last 30 Days</option>
                    </select>
                </div>
                
                <div class="col-md-2">
                    <label class="form-label">Customer</label>
                    <select wire:model.live="customerFilter" class="form-select">
                        <option value="">All Customers</option>
                        @foreach($customers as $customer)
                            <option value="{{ $customer->id }}">{{ $customer->name }}</option>
                        @endforeach
                    </select>
                </div>
                
                <div class="col-md-2">
                    <label class="form-label">Per Page</label>
                    <select wire:model.live="perPage" class="form-select">
                        <option value="10">10</option>
                        <option value="20">20</option>
                        <option value="50">50</option>
                        <option value="100">100</option>
                    </select>
                </div>
                
                <div class="col-md-1 d-flex align-items-end">
                    @if($search || $statusFilter || $dateFilter || $customerFilter)
                        <button wire:click="$set('search', ''); $set('statusFilter', ''); $set('dateFilter', ''); $set('customerFilter', '')" 
                                class="btn btn-outline-secondary w-100">
                            <i class="bi bi-x-lg"></i>
                        </button>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <!-- Orders Table -->
    <div class="card">
        <div class="card-body p-0">
            @if($orders->count() > 0)
                <div class="table-responsive">
                    <table class="table table-hover mb-0">
                        <thead class="table-light">
                            <tr>
                                <th class="border-0">Order #</th>
                                <th class="border-0">Customer</th>
                                <th class="border-0">Date</th>
                                <th class="border-0">Items</th>
                                <th class="border-0">Total</th>
                                <th class="border-0">Status</th>
                                <th class="border-0">Invoice</th>
                                <th class="border-0 text-end">Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($orders as $order)
                                <tr class="cursor-pointer" wire:click="viewOrder({{ $order->id }})">
                                    <td>
                                        <div class="fw-semibold">#{{ $order->order_number }}</div>
                                        @if($order->tracking_number)
                                            <small class="text-muted">
                                                <i class="bi bi-box-seam me-1"></i>{{ $order->tracking_number }}
                                            </small>
                                        @endif
                                    </td>
                                    <td>
                                        <div>{{ $order->user->name }}</div>
                                        <small class="text-muted">{{ $order->user->email }}</small>
                                    </td>
                                    <td>
                                        <div>{{ $order->created_at->format('M j, Y') }}</div>
                                        <small class="text-muted">{{ $order->created_at->format('g:i A') }}</small>
                                    </td>
                                    <td>
                                        <span class="badge bg-light text-dark">
                                            {{ $order->order_lines_count }} {{ Str::plural('item', $order->order_lines_count) }}
                                        </span>
                                    </td>
                                    <td>
                                        <div class="fw-semibold">£{{ number_format($order->initial_total_amount, 2) }}</div>
                                        @if($order->invoiced_total_amount && $order->invoiced_total_amount != $order->initial_total_amount)
                                            <small class="text-muted">
                                                Final: £{{ number_format($order->invoiced_total_amount, 2) }}
                                            </small>
                                        @endif
                                    </td>
                                    <td>
                                        @php
                                            $statusColors = [
                                                'pending' => 'warning',
                                                'confirmed' => 'info',
                                                'processing' => 'primary',
                                                'shipped' => 'success',
                                                'delivered' => 'success',
                                                'cancelled' => 'danger',
                                            ];
                                            $statusIcons = [
                                                'pending' => 'hourglass-split',
                                                'confirmed' => 'check-circle',
                                                'processing' => 'arrow-repeat',
                                                'shipped' => 'truck',
                                                'delivered' => 'check-circle-fill',
                                                'cancelled' => 'x-circle',
                                            ];
                                        @endphp
                                        <span class="badge bg-{{ $statusColors[$order->status] ?? 'secondary' }}">
                                            <i class="bi bi-{{ $statusIcons[$order->status] ?? 'circle' }} me-1"></i>{{ ucfirst($order->status) }}
                                        </span>
                                    </td>
                                    <td>
                                        @if($order->zoho_invoice_number)
                                            <code class="small">{{ $order->zoho_invoice_number }}</code>
                                        @elseif($order->supplier_invoice_number)
                                            <code class="small">{{ $order->supplier_invoice_number }}</code>
                                        @else
                                            <span class="text-muted small">No invoice</span>
                                        @endif
                                    </td>
                                    <td class="text-end" onclick="event.stopPropagation()">
                                        <div class="btn-group btn-group-sm">
                                            <button type="button"
                                                    class="btn btn-outline-primary"
                                                    wire:click="viewOrder({{ $order->id }})"
                                                    onclick="event.stopPropagation()"
                                                    title="View Order">
                                                <i class="bi bi-eye"></i>
                                            </button>
                                            <button type="button"
                                                    class="btn btn-outline-secondary"
                                                    onclick="event.stopPropagation()"
                                                    title="Edit Order">
                                                <i class="bi bi-pencil"></i>
                                            </button>
                                            <button type="button"
                                                    class="btn btn-outline-danger"
                                                    wire:click="deleteOrder({{ $order->id }})"
                                                    onclick="event.stopPropagation(); return confirm('Are you sure you want to delete order #{{ $order->order_number }}? This action cannot be undone.');"
                                                    title="Delete Order">
                                                <i class="bi bi-trash"></i>
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
                
                <!-- Pagination -->
                <div class="d-flex justify-content-between align-items-center p-3 border-top">
                    <div class="text-muted small">
                        Showing {{ $orders->firstItem() }} to {{ $orders->lastItem() }} 
                        of {{ $orders->total() }} orders
                    </div>
                    <div>
                        {{ $orders->links() }}
                    </div>
                </div>
            @else
                <!-- Empty State -->
                <div class="text-center py-5">
                    <i class="bi bi-cart-x display-1 text-muted"></i>
                    <h4 class="mt-3">No orders found</h4>
                    <p class="text-muted">
                        @if($search || $statusFilter || $dateFilter || $customerFilter)
                            No orders match your current filters.
                        @else
                            No orders have been placed yet.
                        @endif
                    </p>
                    @if($search || $statusFilter || $dateFilter || $customerFilter)
                        <button wire:click="$set('search', ''); $set('statusFilter', ''); $set('dateFilter', ''); $set('customerFilter', '')" 
                                class="btn btn-outline-primary">
                            <i class="bi bi-arrow-clockwise me-2"></i>Clear Filters
                        </button>
                    @else
                        <button class="btn btn-primary">
                            <i class="bi bi-plus-lg me-2"></i>Create First Order
                        </button>
                    @endif
                </div>
            @endif
        </div>
    </div>
</div>
