<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class PlaybackStoreRequest extends FormRequest
{
    public function authorize(): bool
    {
        return (bool) $this->user();
    }

    public function rules(): array
    {
        return [
            'track_id' => ['required', 'uuid'],
            'event' => ['required', 'in:play,complete'],
            'at' => ['nullable', 'date'],
        ];
    }
}


