<?php

return [
    'llm' => [
        'driver' => env('LLM_DRIVER', 'null'),
        'drivers' => [
            'null' => [
                'class' => App\Services\LLM\Drivers\NullLLMDriver::class,
            ],
            'openai' => [
                'class' => App\Services\LLM\Drivers\OpenAI\OpenAILLMDriver::class,
                'api_key' => env('LLM_API_KEY'),
                'model' => env('LLM_MODEL', 'gpt-4o-mini'),
                'timeout' => env('LLM_TIMEOUT', 20),
            ],
            'gemini' => [
                'class' => App\Services\LLM\Drivers\Gemini\GeminiLLMDriver::class,
                'api_key' => env('LLM_API_KEY'),
                'model' => env('LLM_MODEL', 'gemini-1.5-pro'),
                'timeout' => env('LLM_TIMEOUT', 20),
            ],
        ],
    ],
    'tts' => [
        'driver' => env('TTS_DRIVER', 'null'),
        'drivers' => [
            'null' => [
                'class' => App\Services\TTS\Drivers\NullTTSDriver::class,
            ],
            'google' => [
                'class' => App\Services\TTS\Drivers\Google\GoogleTTSDriver::class,
                'api_key' => env('TTS_API_KEY'),
                'voice_defaults' => [
                    'gender' => 'female',
                    'language_code' => 'en-GB',
                ],
                'timeout' => env('TTS_TIMEOUT', 30),
            ],
        ],
    ],
];


