<?php

return [
    'llm' => [
        'default' => env('LLM_DRIVER', 'null'),
        'drivers' => [
            'null' => [
                'class' => \App\Services\LLM\Drivers\NullLLMDriver::class,
            ],
            'openai' => [
                'class' => \App\Services\LLM\Drivers\OpenAIDriver::class,
                'api_key' => env('OPENAI_API_KEY'),
                'model' => env('OPENAI_MODEL', 'gpt-4'),
            ],
        ],
    ],
    
    'tts' => [
        'default' => env('TTS_DRIVER', 'null'),
        'drivers' => [
            'null' => [
                'class' => \App\Services\TTS\Drivers\NullTTSDriver::class,
            ],
            'elevenlabs' => [
                'class' => \App\Services\TTS\Drivers\ElevenLabsDriver::class,
                'api_key' => env('ELEVENLABS_API_KEY'),
                'voice_id' => env('ELEVENLABS_VOICE_ID'),
            ],
        ],
    ],
];
