@extends('layouts.shop')

@section('title', 'Privacy Policy - Yarn Store')

@section('content')
<div class="py-4" style="background-color: var(--ys-bg-section);">
    <div class="container">
        <h1 class="fw-bold mb-0">Privacy Policy</h1>
    </div>
</div>

<div class="container py-5">
    <div class="row">
        <div class="col-lg-9 mx-auto">
            <div class="ys-card p-4">
                <p class="text-muted small mb-4">Last updated: {{ date('F d, Y') }}</p>

                <h3 class="fw-bold mb-3">1. Introduction</h3>
                <p>Robert Todd Yarn Ltd ("we", "us", "our") is committed to protecting your privacy. This policy explains how we collect, use, and protect your personal information.</p>

                <h3 class="fw-bold mb-3 mt-4">2. Information We Collect</h3>
                <p>We collect the following types of information:</p>
                <ul>
                    <li><strong>Account Information:</strong> Name, email address, phone number</li>
                    <li><strong>Order Information:</strong> Billing and shipping addresses, payment information</li>
                    <li><strong>Technical Information:</strong> IP address, browser type, device information</li>
                    <li><strong>Usage Information:</strong> How you interact with our website</li>
                </ul>

                <h3 class="fw-bold mb-3 mt-4">3. How We Use Your Information</h3>
                <p>We use your information to:</p>
                <ul>
                    <li>Process and fulfill your orders</li>
                    <li>Communicate with you about your orders</li>
                    <li>Send marketing communications (with your consent)</li>
                    <li>Improve our website and services</li>
                    <li>Comply with legal obligations</li>
                </ul>

                <h3 class="fw-bold mb-3 mt-4">4. Legal Basis for Processing</h3>
                <p>We process your data based on:</p>
                <ul>
                    <li>Contract performance (to fulfill your orders)</li>
                    <li>Legitimate interests (to improve our services)</li>
                    <li>Consent (for marketing communications)</li>
                    <li>Legal obligations (for tax and accounting)</li>
                </ul>

                <h3 class="fw-bold mb-3 mt-4">5. Data Retention</h3>
                <p>We retain your personal data for as long as necessary to fulfill the purposes outlined in this policy, typically for the duration of your account plus 7 years for tax purposes.</p>

                <h3 class="fw-bold mb-3 mt-4">6. Your Rights</h3>
                <p>Under UK GDPR, you have the right to:</p>
                <ul>
                    <li>Access your personal data</li>
                    <li>Correct inaccurate data</li>
                    <li>Request deletion of your data</li>
                    <li>Object to processing</li>
                    <li>Data portability</li>
                    <li>Withdraw consent</li>
                </ul>

                <h3 class="fw-bold mb-3 mt-4">7. Data Security</h3>
                <p>We implement appropriate technical and organizational measures to protect your data, including encryption, secure servers, and access controls.</p>

                <h3 class="fw-bold mb-3 mt-4">8. Third-Party Services</h3>
                <p>We may share your data with trusted third parties including:</p>
                <ul>
                    <li>Payment processors</li>
                    <li>Shipping carriers</li>
                    <li>Email service providers</li>
                    <li>Analytics providers</li>
                </ul>

                <h3 class="fw-bold mb-3 mt-4">9. Cookies</h3>
                <p>We use cookies to enhance your browsing experience. See our <a href="{{ route('cookies') }}">Cookie Policy</a> for details.</p>

                <h3 class="fw-bold mb-3 mt-4">10. Contact Us</h3>
                <p>For privacy-related queries, contact us at:<br>
                Email: privacy@yarnstore.co.uk<br>
                Address: Robert Todd Yarn Ltd, [Address]</p>
            </div>
        </div>
    </div>
</div>
@endsection




