@extends('layouts.shop')

@section('title', 'Yarn Care Guide - Yarn Store')
@section('meta_description', 'Learn how to care for your precious yarn projects. Expert tips on washing, drying, and storing your handmade items.')

@section('content')
<div class="py-4" style="background-color: var(--ys-bg-section);">
    <div class="container">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb ys-breadcrumb">
                <li class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></li>
                <li class="breadcrumb-item"><a href="{{ route('guides.care') }}">Guides</a></li>
                <li class="breadcrumb-item active">Yarn Care</li>
            </ol>
        </nav>
        <h1 class="fw-bold mb-0">Yarn Care Guide</h1>
    </div>
</div>

<div class="container py-5">
    <div class="row">
        <div class="col-lg-9 mx-auto">
            <div class="ys-card p-4 mb-4">
                <p class="lead">Proper care ensures your handmade items remain beautiful for years to come. Follow these guidelines to keep your projects looking their best.</p>

                <h3 class="fw-bold mt-4 mb-3">Understanding Care Symbols</h3>
                <p>Always check the yarn label for specific care instructions. Common symbols include:</p>
                <ul>
                    <li><strong>Hand wash:</strong> Gentle washing in cool water</li>
                    <li><strong>Machine washable:</strong> Use gentle cycle and cool water</li>
                    <li><strong>Dry flat:</strong> Reshape and lay flat to dry</li>
                    <li><strong>Do not bleach:</strong> Never use bleach or harsh chemicals</li>
                </ul>

                <h3 class="fw-bold mt-4 mb-3">Washing Your Knits</h3>
                <h5 class="fw-bold mt-3">Hand Washing (Recommended)</h5>
                <ol>
                    <li>Fill a basin with cool water and add wool-safe detergent</li>
                    <li>Gently submerge the item and let soak for 10-15 minutes</li>
                    <li>Gently squeeze (don't wring) to remove excess water</li>
                    <li>Rinse in clean cool water until soap is removed</li>
                    <li>Roll in a towel to remove more water</li>
                </ol>

                <h5 class="fw-bold mt-3">Machine Washing</h5>
                <p>If the yarn label allows machine washing:</p>
                <ul>
                    <li>Use a mesh laundry bag</li>
                    <li>Select gentle/delicate cycle</li>
                    <li>Use cool water (30°C or below)</li>
                    <li>Use wool-safe detergent</li>
                    <li>Never use fabric softener</li>
                </ul>

                <h3 class="fw-bold mt-4 mb-3">Drying</h3>
                <p><strong>Always dry flat:</strong></p>
                <ol>
                    <li>Reshape the item to its original dimensions</li>
                    <li>Lay flat on a clean, dry towel</li>
                    <li>Keep away from direct heat and sunlight</li>
                    <li>Turn over periodically to ensure even drying</li>
                    <li>Never tumble dry unless specifically stated</li>
                </ol>

                <h3 class="fw-bold mt-4 mb-3">Storage Tips</h3>
                <ul>
                    <li>Store clean items in breathable containers</li>
                    <li>Fold rather than hang to prevent stretching</li>
                    <li>Use cedar blocks or lavender sachets to deter moths</li>
                    <li>Keep in a cool, dry place away from direct sunlight</li>
                    <li>Check stored items periodically</li>
                </ul>

                <h3 class="fw-bold mt-4 mb-3">Dealing with Pilling</h3>
                <p>Pilling is natural and can be managed:</p>
                <ul>
                    <li>Use a fabric shaver or de-pilling comb</li>
                    <li>Gently remove pills by hand</li>
                    <li>Turn items inside out when washing to reduce friction</li>
                </ul>

                <h3 class="fw-bold mt-4 mb-3">Stain Removal</h3>
                <p>Act quickly for best results:</p>
                <ol>
                    <li>Blot (don't rub) fresh stains immediately</li>
                    <li>Use cool water and wool-safe stain remover</li>
                    <li>Test on an inconspicuous area first</li>
                    <li>For stubborn stains, consult a professional cleaner</li>
                </ol>
            </div>

            <div class="text-center p-4" style="background-color: var(--ys-bg-section); border-radius: 0.5rem;">
                <h4 class="fw-bold mb-3">Need More Help?</h4>
                <p class="text-muted mb-3">Contact our team for personalized advice on caring for your specific yarn</p>
                <a href="{{ route('contact') }}" class="btn btn-ys-primary">Contact Us</a>
            </div>
        </div>
    </div>
</div>
@endsection

