@extends('layouts.shop')

@section('title', 'Terms & Conditions - Yarn Store')

@section('content')
<div class="py-4" style="background-color: var(--ys-bg-section);">
    <div class="container">
        <h1 class="fw-bold mb-0">Terms & Conditions</h1>
    </div>
</div>

<div class="container py-5">
    <div class="row">
        <div class="col-lg-9 mx-auto">
            <div class="ys-card p-4">
                <p class="text-muted small mb-4">Last updated: {{ date('F d, Y') }}</p>

                <h3 class="fw-bold mb-3">1. Introduction</h3>
                <p>Welcome to Yarn Store (operated by Robert Todd Yarn Ltd). These terms and conditions outline the rules and regulations for the use of our website and the purchase of products.</p>

                <h3 class="fw-bold mb-3 mt-4">2. Interpretation</h3>
                <p>In these terms and conditions:</p>
                <ul>
                    <li>"Company" refers to Robert Todd Yarn Ltd</li>
                    <li>"Customer" refers to you, the purchaser of goods</li>
                    <li>"Goods" refers to the yarn and related products sold on this website</li>
                </ul>

                <h3 class="fw-bold mb-3 mt-4">3. Orders and Acceptance</h3>
                <p>When you place an order through our website, you are making an offer to purchase goods. We reserve the right to accept or decline your order. Acceptance occurs when we send you an order confirmation email.</p>

                <h3 class="fw-bold mb-3 mt-4">4. Pricing</h3>
                <p>All prices are displayed in GBP (£) and include VAT where applicable. We reserve the right to change prices at any time, but changes will not affect orders already confirmed.</p>

                <h3 class="fw-bold mb-3 mt-4">5. Payment</h3>
                <p>Payment must be made at the time of ordering. We accept major credit cards, debit cards, and PayPal. All transactions are processed securely.</p>

                <h3 class="fw-bold mb-3 mt-4">6. Delivery</h3>
                <p>We aim to dispatch orders within 1-2 business days. UK delivery is free on orders over £50. Delivery times are estimates and not guaranteed.</p>

                <h3 class="fw-bold mb-3 mt-4">7. Returns and Cancellations</h3>
                <p>You have the right to cancel your order within 14 days of receipt. Items must be returned in original condition. Please see our Returns Policy for full details.</p>

                <h3 class="fw-bold mb-3 mt-4">8. Limitation of Liability</h3>
                <p>We shall not be liable for any indirect or consequential losses. Our liability is limited to the purchase price of the goods.</p>

                <h3 class="fw-bold mb-3 mt-4">9. Governing Law</h3>
                <p>These terms are governed by the laws of England and Wales.</p>

                <h3 class="fw-bold mb-3 mt-4">10. Contact Us</h3>
                <p>If you have any questions about these terms, please contact us at info@yarnstore.co.uk</p>
            </div>
        </div>
    </div>
</div>
@endsection

