<?php
$meta = [
  'title' => 'Case Study | Example',
  'description' => 'A simple case study showing problem, what we did, and outcome.',
  'canonical' => 'https://neilwiddowson.co.uk/portfolio/case-template.php'
];
$currentPage = 'portfolio';
include __DIR__.'/../includes/header.php';
?>

<main id="main-content" class="section">
  <div class="container max-w-3xl">
    <h1 class="text-3xl font-bold tracking-tight">Case study: Business type</h1>
    <div class="mt-6 grid gap-6 md:grid-cols-2">
      <div class="card p-4">
        <h2 class="font-semibold text-gray-900">Problem</h2>
        <p class="mt-2 text-sm text-gray-700">Short description of the issue the client faced.</p>
      </div>
      <div class="card p-4">
        <h2 class="font-semibold text-gray-900">What we did</h2>
        <p class="mt-2 text-sm text-gray-700">Steps we took: design tidy, clear services, speed tweaks.</p>
      </div>
    </div>
    <div class="card p-4 mt-6">
      <h2 class="font-semibold text-gray-900">Outcome</h2>
      <p class="mt-2 text-sm text-gray-700">Prefer numeric or specific result: more enquiries, faster load time, etc.</p>
    </div>
    <div class="mt-6">
      <a href="/portfolio/" class="btn-secondary">Back to portfolio</a>
    </div>
  </div>
</main>

<?php include __DIR__.'/../includes/footer.php'; ?>
