<?php

namespace App\Livewire\Library;

use App\Contracts\LibraryService;
use App\Contracts\PlaybackService;
use App\Models\Track;
use Livewire\Attributes\Validate;
use Livewire\Component;

class TrackShow extends Component
{
    public string $trackId;

    public ?Track $track = null;
    public ?string $audioUrl = null;

    public function mount(string $track, LibraryService $library): void
    {
        $this->trackId = $track;
        $this->track = Track::with(['voiceActor', 'tags'])->findOrFail($track);
        $this->audioUrl = $library->getSignedAudioUrl($this->track);
    }

    public function play(PlaybackService $playback): void
    {
        $playback->log('play', auth()->user(), $this->track);
        $this->dispatch('toast', type: 'success', message: 'Playing');
    }

    public function complete(PlaybackService $playback): void
    {
        $playback->log('complete', auth()->user(), $this->track);
        $this->dispatch('toast', type: 'success', message: 'Completed');
    }

    public function render()
    {
        return view('livewire.library.track-show');
    }
}


