<?php

namespace App\Livewire\Library;

use App\Contracts\LibraryService;
use App\Contracts\PlaybackService;
use App\Models\Track;
use Livewire\Attributes\Validate;
use Livewire\Component;

class TrackShow extends Component
{
    public string $trackId;

    public ?Track $track = null;
    public ?string $audioUrl = null;
    public bool $busy = false;

    public function mount(string $track, LibraryService $library): void
    {
        $this->trackId = $track;
        $this->track = Track::with(['voiceActor', 'tags'])->findOrFail($track);
        $this->audioUrl = $library->getSignedAudioUrl($this->track);
    }

    public function play(PlaybackService $playback): void
    {
        if ($this->busy) return;
        $this->busy = true;
        try {
            $playback->log('play', auth()->user(), $this->track);
            $this->dispatch('toast', type: 'success', message: 'Playing');
        } finally {
            $this->busy = false;
        }
    }

    public function complete(PlaybackService $playback): void
    {
        if ($this->busy) return;
        $this->busy = true;
        try {
            $playback->log('complete', auth()->user(), $this->track);
            $this->dispatch('toast', type: 'success', message: 'Completed');
        } finally {
            $this->busy = false;
        }
    }

    public function render()
    {
        return view('livewire.library.track-show');
    }
}


