<div class="space-y-6">
    <!-- Header -->
    <div class="flex justify-between items-center">
        <div>
            <h2 class="text-2xl font-bold text-gray-900 dark:text-white">Receipt Grouping</h2>
            <p class="text-sm text-gray-600 dark:text-gray-400">Group related receipts together for better transaction matching</p>
        </div>
        <div class="flex gap-3">
            <button wire:click="showSuggestionsModal" class="px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700 transition-colors">
                <svg class="w-4 h-4 inline mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9.663 17h4.673M12 3v1m6.364 1.636l-.707.707M21 12h-1M4 12H3m3.343-5.657l-.707-.707m2.828 9.9a5 5 0 117.072 0l-.548.547A3.374 3.374 0 0014 18.469V19a2 2 0 11-4 0v-.531c0-.895-.356-1.754-.988-2.386l-.548-.547z"/>
                </svg>
                AI Suggestions
            </button>
            <button wire:click="showCreateGroupModal" 
                    wire:disabled="empty($selectedReceipts)"
                    class="px-4 py-2 bg-green-600 text-white rounded-lg hover:bg-green-700 disabled:bg-gray-400 disabled:cursor-not-allowed transition-colors">
                <svg class="w-4 h-4 inline mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"/>
                </svg>
                Create Group
            </button>
        </div>
    </div>

    <!-- Selection Controls -->
    @if(!empty($selectedReceipts))
    <div class="bg-blue-50 dark:bg-blue-900/20 border border-blue-200 dark:border-blue-700 rounded-lg p-4">
        <div class="flex items-center justify-between">
            <div class="flex items-center gap-2">
                <svg class="w-5 h-5 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                </svg>
                <span class="font-medium text-blue-900 dark:text-blue-100">
                    {{ count($selectedReceipts) }} receipt(s) selected
                </span>
            </div>
            <button wire:click="clearSelection" class="text-blue-600 hover:text-blue-800 dark:text-blue-400 dark:hover:text-blue-200">
                Clear Selection
            </button>
        </div>
    </div>
    @endif

    <!-- Tabs -->
    <div class="border-b border-gray-200 dark:border-gray-700">
        <nav class="-mb-px flex space-x-8">
            <button class="py-2 px-1 border-b-2 border-blue-500 font-medium text-sm text-blue-600 dark:text-blue-400">
                Unmatched Receipts
            </button>
            <button class="py-2 px-1 border-b-2 border-transparent font-medium text-sm text-gray-500 hover:text-gray-700 dark:text-gray-400 dark:hover:text-gray-300">
                Receipt Groups
            </button>
        </nav>
    </div>

    <!-- Unmatched Receipts -->
    <div class="space-y-4">
        <div class="flex justify-between items-center">
            <h3 class="text-lg font-semibold text-gray-900 dark:text-white">Unmatched Receipts</h3>
            <div class="flex gap-2">
                <button wire:click="selectAllReceipts" class="px-3 py-1 text-sm border border-gray-300 rounded-md hover:bg-gray-50 dark:border-gray-600 dark:hover:bg-gray-700">
                    Select All
                </button>
                <button wire:click="clearSelection" class="px-3 py-1 text-sm border border-gray-300 rounded-md hover:bg-gray-50 dark:border-gray-600 dark:hover:bg-gray-700">
                    Clear All
                </button>
            </div>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
            @forelse($unmatchedReceipts as $receipt)
            <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4 hover:shadow-md transition-shadow">
                <div class="flex items-start justify-between mb-3">
                    <div class="flex items-center">
                        <input type="checkbox" 
                               wire:click="selectReceipt({{ $receipt->id }})"
                               @if(in_array($receipt->id, $selectedReceipts)) checked @endif
                               class="h-4 w-4 text-blue-600 focus:ring-blue-500 border-gray-300 rounded">
                        <div class="ml-3">
                            <h4 class="font-medium text-gray-900 dark:text-white">{{ $receipt->merchant_name }}</h4>
                            <p class="text-sm text-gray-500 dark:text-gray-400">{{ $receipt->receipt_date?->format('M j, Y') }}</p>
                        </div>
                    </div>
                    <span class="text-lg font-semibold text-green-600 dark:text-green-400">
                        £{{ number_format($receipt->total_amount, 2) }}
                    </span>
                </div>
                
                @if($receipt->lines->count() > 0)
                <div class="text-xs text-gray-500 dark:text-gray-400 mb-2">
                    {{ $receipt->lines->count() }} line(s) • {{ $receipt->lines->where('description', '!=', '')->count() }} detailed
                </div>
                @endif

                <div class="flex items-center justify-between text-xs text-gray-500 dark:text-gray-400">
                    <span>{{ optional($receipt->department)->name ?? 'No dept' }}</span>
                    <span>{{ optional($receipt->account)->name ?? 'No account' }}</span>
                </div>
            </div>
            @empty
            <div class="col-span-full text-center py-12">
                <svg class="w-12 h-12 mx-auto text-gray-400 mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/>
                </svg>
                <p class="text-gray-500 dark:text-gray-400">No unmatched receipts found</p>
            </div>
            @endforelse
        </div>

        {{ $unmatchedReceipts->links() }}
    </div>

    <!-- Receipt Groups -->
    <div class="space-y-4">
        <h3 class="text-lg font-semibold text-gray-900 dark:text-white">Receipt Groups</h3>
        
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
            @forelse($receiptGroups as $group)
            <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4 hover:shadow-md transition-shadow">
                <div class="flex items-start justify-between mb-3">
                    <div>
                        <h4 class="font-medium text-gray-900 dark:text-white">{{ $group->name }}</h4>
                        <p class="text-sm text-gray-500 dark:text-gray-400">{{ $group->receipts->count() }} receipt(s)</p>
                    </div>
                    <div class="flex gap-1">
                        <button wire:click="viewGroup({{ $group->id }})" class="p-1 text-gray-400 hover:text-blue-600">
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"/>
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"/>
                            </svg>
                        </button>
                        <button wire:click="deleteGroup({{ $group->id }})" 
                                wire:confirm="Are you sure you want to delete this group?"
                                class="p-1 text-gray-400 hover:text-red-600">
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"/>
                            </svg>
                        </button>
                    </div>
                </div>

                <div class="space-y-2">
                    <div class="flex justify-between text-sm">
                        <span class="text-gray-500 dark:text-gray-400">Total Amount:</span>
                        <span class="font-semibold text-green-600 dark:text-green-400">£{{ number_format($group->total_amount, 2) }}</span>
                    </div>
                    <div class="flex justify-between text-sm">
                        <span class="text-gray-500 dark:text-gray-400">Primary Merchant:</span>
                        <span class="text-gray-900 dark:text-white">{{ $group->primary_merchant ?? 'N/A' }}</span>
                    </div>
                    <div class="flex justify-between text-sm">
                        <span class="text-gray-500 dark:text-gray-400">Method:</span>
                        <span class="px-2 py-1 text-xs rounded-full 
                            @if($group->grouping_method === 'ai_auto') bg-blue-100 text-blue-800 dark:bg-blue-900/20 dark:text-blue-300
                            @elseif($group->grouping_method === 'ai_suggested') bg-purple-100 text-purple-800 dark:bg-purple-900/20 dark:text-purple-300
                            @else bg-gray-100 text-gray-800 dark:bg-gray-700 dark:text-gray-300 @endif">
                            {{ ucfirst(str_replace('_', ' ', $group->grouping_method)) }}
                        </span>
                    </div>
                    @if($group->hasMatches())
                    <div class="text-xs text-green-600 dark:text-green-400">
                        ✓ Has matched transactions
                    </div>
                    @endif
                </div>
            </div>
            @empty
            <div class="col-span-full text-center py-12">
                <svg class="w-12 h-12 mx-auto text-gray-400 mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 11H5m14 0a2 2 0 012 2v6a2 2 0 01-2 2H5a2 2 0 01-2-2v-6a2 2 0 012-2m14 0V9a2 2 0 00-2-2M5 11V9a2 2 0 012-2m0 0V5a2 2 0 012-2h6a2 2 0 012 2v2M7 7h10"/>
                </svg>
                <p class="text-gray-500 dark:text-gray-400">No receipt groups found</p>
            </div>
            @endforelse
        </div>

        {{ $receiptGroups->links() }}
    </div>

    <!-- Create Group Modal -->
    @if($showCreateGroupModal)
    <div class="fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full z-50" wire:click="closeModals">
        <div class="relative top-20 mx-auto p-5 border w-96 shadow-lg rounded-md bg-white dark:bg-gray-800" wire:click.stop>
            <div class="mt-3">
                <h3 class="text-lg font-medium text-gray-900 dark:text-white mb-4">Create Receipt Group</h3>
                
                <form wire:submit="createGroup">
                    <div class="mb-4">
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Group Name</label>
                        <input type="text" wire:model="groupName" 
                               class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500 dark:bg-gray-700 dark:border-gray-600 dark:text-white"
                               placeholder="Enter group name">
                        @error('groupName') <span class="text-red-500 text-xs">{{ $message }}</span> @enderror
                    </div>

                    <div class="mb-4">
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Description (Optional)</label>
                        <textarea wire:model="groupDescription" rows="3"
                                  class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500 dark:bg-gray-700 dark:border-gray-600 dark:text-white"
                                  placeholder="Enter description"></textarea>
                        @error('groupDescription') <span class="text-red-500 text-xs">{{ $message }}</span> @enderror
                    </div>

                    <div class="flex justify-end space-x-3">
                        <button type="button" wire:click="closeModals" 
                                class="px-4 py-2 text-sm font-medium text-gray-700 bg-gray-100 border border-gray-300 rounded-md hover:bg-gray-200 dark:bg-gray-600 dark:text-gray-300 dark:border-gray-500 dark:hover:bg-gray-700">
                            Cancel
                        </button>
                        <button type="submit" 
                                class="px-4 py-2 text-sm font-medium text-white bg-blue-600 border border-transparent rounded-md hover:bg-blue-700">
                            Create Group
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    @endif

    <!-- AI Suggestions Modal -->
    @if($showSuggestionsModal)
    <div class="fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full z-50" wire:click="closeModals">
        <div class="relative top-20 mx-auto p-5 border w-full max-w-4xl shadow-lg rounded-md bg-white dark:bg-gray-800" wire:click.stop>
            <div class="mt-3">
                <div class="flex justify-between items-center mb-4">
                    <h3 class="text-lg font-medium text-gray-900 dark:text-white">AI Grouping Suggestions</h3>
                    <button wire:click="closeModals" class="text-gray-400 hover:text-gray-600">
                        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/>
                        </svg>
                    </button>
                </div>

                @if(empty($aiSuggestions))
                <div class="text-center py-8">
                    <svg class="w-12 h-12 mx-auto text-gray-400 mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9.663 17h4.673M12 3v1m6.364 1.636l-.707.707M21 12h-1M4 12H3m3.343-5.657l-.707-.707m2.828 9.9a5 5 0 117.072 0l-.548.547A3.374 3.374 0 0014 18.469V19a2 2 0 11-4 0v-.531c0-.895-.356-1.754-.988-2.386l-.548-.547z"/>
                    </svg>
                    <p class="text-gray-500 dark:text-gray-400">No AI suggestions available at this time</p>
                </div>
                @else
                <div class="space-y-4">
                    @foreach($aiSuggestions as $index => $suggestion)
                    <div class="border border-gray-200 dark:border-gray-700 rounded-lg p-4">
                        <div class="flex justify-between items-start mb-2">
                            <div>
                                <h4 class="font-medium text-gray-900 dark:text-white">{{ $suggestion['group_name'] ?? 'Unnamed Group' }}</h4>
                                <p class="text-sm text-gray-500 dark:text-gray-400">{{ $suggestion['reasoning'] ?? 'No reasoning provided' }}</p>
                            </div>
                            <div class="flex items-center gap-2">
                                <span class="px-2 py-1 text-xs rounded-full 
                                    @if($suggestion['confidence'] >= 0.8) bg-green-100 text-green-800 dark:bg-green-900/20 dark:text-green-300
                                    @elseif($suggestion['confidence'] >= 0.6) bg-yellow-100 text-yellow-800 dark:bg-yellow-900/20 dark:text-yellow-300
                                    @else bg-red-100 text-red-800 dark:bg-red-900/20 dark:text-red-300 @endif">
                                    {{ round($suggestion['confidence'] * 100) }}% confidence
                                </span>
                                <button wire:click="applySuggestion({{ $index }})" 
                                        class="px-3 py-1 text-sm bg-blue-600 text-white rounded hover:bg-blue-700">
                                    Apply
                                </button>
                            </div>
                        </div>
                        <div class="text-xs text-gray-500 dark:text-gray-400">
                            Receipt IDs: {{ implode(', ', $suggestion['receipt_ids'] ?? []) }}
                        </div>
                    </div>
                    @endforeach
                </div>
                @endif
            </div>
        </div>
    </div>
    @endif

    <!-- Group Details Modal -->
    @if($showGroupDetails && $selectedGroup)
    <div class="fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full z-50" wire:click="closeModals">
        <div class="relative top-20 mx-auto p-5 border w-full max-w-4xl shadow-lg rounded-md bg-white dark:bg-gray-800" wire:click.stop>
            <div class="mt-3">
                <div class="flex justify-between items-center mb-4">
                    <h3 class="text-lg font-medium text-gray-900 dark:text-white">{{ $selectedGroup->name }}</h3>
                    <button wire:click="closeModals" class="text-gray-400 hover:text-gray-600">
                        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/>
                        </svg>
                    </button>
                </div>

                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <!-- Group Info -->
                    <div>
                        <h4 class="font-medium text-gray-900 dark:text-white mb-3">Group Information</h4>
                        <div class="space-y-2 text-sm">
                            <div class="flex justify-between">
                                <span class="text-gray-500 dark:text-gray-400">Total Amount:</span>
                                <span class="font-semibold text-green-600 dark:text-green-400">£{{ number_format($selectedGroup->total_amount, 2) }}</span>
                            </div>
                            <div class="flex justify-between">
                                <span class="text-gray-500 dark:text-gray-400">Receipt Count:</span>
                                <span>{{ $selectedGroup->receipts->count() }}</span>
                            </div>
                            <div class="flex justify-between">
                                <span class="text-gray-500 dark:text-gray-400">Primary Merchant:</span>
                                <span>{{ $selectedGroup->primary_merchant ?? 'N/A' }}</span>
                            </div>
                            <div class="flex justify-between">
                                <span class="text-gray-500 dark:text-gray-400">Grouping Method:</span>
                                <span class="px-2 py-1 text-xs rounded-full 
                                    @if($selectedGroup->grouping_method === 'ai_auto') bg-blue-100 text-blue-800 dark:bg-blue-900/20 dark:text-blue-300
                                    @elseif($selectedGroup->grouping_method === 'ai_suggested') bg-purple-100 text-purple-800 dark:bg-purple-900/20 dark:text-purple-300
                                    @else bg-gray-100 text-gray-800 dark:bg-gray-700 dark:text-gray-300 @endif">
                                    {{ ucfirst(str_replace('_', ' ', $selectedGroup->grouping_method)) }}
                                </span>
                            </div>
                            @if($selectedGroup->confidence_score)
                            <div class="flex justify-between">
                                <span class="text-gray-500 dark:text-gray-400">Confidence:</span>
                                <span>{{ round($selectedGroup->confidence_score * 100) }}%</span>
                            </div>
                            @endif
                        </div>
                    </div>

                    <!-- Receipts in Group -->
                    <div>
                        <h4 class="font-medium text-gray-900 dark:text-white mb-3">Receipts in Group</h4>
                        <div class="space-y-2 max-h-64 overflow-y-auto">
                            @foreach($selectedGroup->receipts as $receipt)
                            <div class="flex items-center justify-between p-2 bg-gray-50 dark:bg-gray-700 rounded">
                                <div>
                                    <div class="font-medium text-sm">{{ $receipt->merchant_name }}</div>
                                    <div class="text-xs text-gray-500 dark:text-gray-400">
                                        {{ $receipt->receipt_date?->format('M j, Y') }} • £{{ number_format($receipt->total_amount, 2) }}
                                    </div>
                                </div>
                                <button wire:click="ungroupReceipt({{ $receipt->id }})" 
                                        wire:confirm="Remove this receipt from the group?"
                                        class="p-1 text-red-600 hover:text-red-800">
                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/>
                                    </svg>
                                </button>
                            </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @endif
</div>