<?php

namespace App\Helper;

use Exception;
use Carbon\Carbon;
use App\Models\Seasons;
use Carbon\CarbonPeriod;
use Illuminate\Support\Facades\Gate;


class Functions
{


    private static function getPriceCount($prices, $all = FALSE){
        // if(Gate::check('asdasd')){
        //     dd($prices);
        // }
        if($all)
            $prices = $prices->where('sizes_id', 1)->whereNULL('colour_type')->whereNULL('colourways_id');
        if($prices->where('quote_status', 'confirmed')->count() == 1){
            return $prices->where('quote_status', 'confirmed')->first();
        }
        if($prices->where('quote_status', 'confirmed')->count() > 1){
            return 'Many Confirmed';
        }
        if($prices->count() == 1){
            return $prices->first();
        }
        if($prices->unique('quote')->count() == 1){
            return $prices->first();
        }
        else{
            return 'Many Prices';
        }
    }

    public static function sanitise($var){
        if(is_string($var)){
            $var = trim(strip_tags($var));
        }
        elseif(is_array($var)){
            array_walk_recursive(
                    $var,
                    function(&$string) {
                        if (is_string($string)) {
                            $string = trim(strip_tags($string));
                        }
                    }
                );
        }
        return $var;
    }


    /**
     * @deprecated Use total cache system instead
     * This function is kept for legacy compatibility only
     */
    public static function newAddPricing($shipments){


        $seasons = Seasons::allCached();

        foreach($shipments as $s=>$shipment){
            $season = $seasons->find($shipment->seasons_id);

            $shipments[$s]->quote_total = 0;
            $shipments[$s]->cmt_total = 0;
            $quotes = [];

            foreach($shipment->sizes ?? [] as $slq){
                if(collect($shipment->sizes)->where('shipped_qty', '!=', 0)->first() == NULL){
                    $qty = $slq->qty;
                }
                else{
                    $qty = $slq->shipped_qty ?? 0;
                }

                if(!is_array($shipment->prices)){
                    $prices = json_decode($shipment->prices);
                }
                else{
                    $prices = $shipment->prices;
                }
                $price = Functions::getPrice($prices, $slq->sizes_id, $shipment->colour_type, $shipment->colourways_id);  //CHANGED

                //IF DIFFERENT PRICES FRO SIZES RETURN MANY PRICES / OR ADD THEM TO SIZES MATRIX
                if(!is_string($price)){
                    $quotes[] = $price->id ?? $price->price_id;
                    $shipments[$s]->quote_total = $shipments[$s]->quote_total + ($qty * $price->quote);
                    $shipments[$s]->cmt_total = $shipments[$s]->cmt_total + ($qty * $price->cmt);
                    if(!empty($price->yarn_value))
                        $shipments[$s]->yarn_total = $shipments[$s]->yarn_total + ($qty * $price->yarn_value);
                }
            }
            if(!is_string($price)){

                $shipments[$s]->quote_total_base = Conversions::convertCurrency($shipment->cust_currency, "£", $shipments[$s]->quote_total, $season);
                $shipments[$s]->cmt_total_base = Conversions::convertCurrency($shipment->fact_currency, "£", $shipments[$s]->cmt_total, $season);
                $shipments[$s]->yarn_total_base = Conversions::convertCurrency("€", "£", $shipments[$s]->yarn_total ?? 0, $season);
                $allValuesAreTheSame = (count(array_unique($quotes, SORT_REGULAR)) === 1);
                if($allValuesAreTheSame)
                    $shipments[$s]->price = $price;
                else
                    $shipments[$s]->price = "Many";
            }
            else{
                $shipments[$s]->price = $price;
            }
            // dd($shipments[$s]);
        }
        // dd($shipments);
		return $shipments;
    }


	/**
     * @deprecated Use total cache system instead
     * This function is kept for legacy compatibility only
     */
	public static function addPricing($shipments, $seasons, $season = NULL){
		if(empty($size)){
			$size = (object) ['sizes_id' => 0];
		}
		foreach($shipments as $s=>$shipment){
			// dd($shipment);
			if(empty($season))
            	$season = $seasons->find($shipment->seasons_id);
            $price = Functions::getPrice(json_decode($shipment->prices), $size->sizes_id, $shipment->colour_type, $shipment->colourways_id);  //CHANGED
            if(!is_string($price)){
                $shipment->quote = $price->quote;
                $shipment->quote_status = $price->quote_status;
                $shipment->cmt = $price->cmt;
                $shipment->cmt_status = $price->quote_status;
                $shipment->transport_budget = $price->transport_budget;
                if(!empty(json_decode($shipment->shipped_sizes)) && array_sum(array_column(json_decode($shipment->shipped_sizes), 'qty')) != 0){
					#CMT
						$total = 0;
						foreach(json_decode($shipment->shipped_sizes) as $size){
							$sPrice = Functions::getPrice(json_decode($shipment->prices), $size->sizes_id, $shipment->colour_type, $shipment->colourways_id);
							if(!is_string($sPrice)){
								$total = $total + ($size->qty * $sPrice->cmt);
							}
						}
						$shipment->cmt_total = $total;
						$shipment->cmt_total_base = Conversions::convertCurrency($shipment->fact_currency, "£", $total, $season);
					#QUOTE
						$total = 0;
						foreach(json_decode($shipment->shipped_sizes) as $size){
							$sPrice = Functions::getPrice(json_decode($shipment->prices), $size->sizes_id, $shipment->colour_type, $shipment->colourways_id);
							if(!is_string($sPrice)){
								$total = $total + ($size->qty * $sPrice->quote);
							}
						}
						$shipment->quote_total = $total;
						$shipment->quote_total_base = Conversions::convertCurrency($shipment->cust_currency, "£", $total, $season);
						// dd($shipment->cust_currency, $total, $season);
						if($shipment->customer_factored){
							$shipment->quote_total_factor_amt = $shipment->quote_total * .8;
							$shipment->quote_total_factor_amt_base = Conversions::convertCurrency($shipment->cust_currency, "£", $shipment->quote_total, $season) * .8;
                        }
						else{
							$shipment->quote_total_factor_amt = 0;
                            $shipment->quote_total_factor_amt_base = 0;
                        }
						$shipment->remaining_factored = $shipment->quote_total - $shipment->quote_total_factor_amt;
						$shipment->remaining_factored_base = $shipment->quote_total_base - $shipment->quote_total_factor_amt_base;
						$shipment->remaining_factored_week = Carbon::parse($shipment->revised_exfty)->addDays($shipment->customer_terms)->startOfWeek()->format('Y-m-d');
				}
				else{
					#CMT
					if(!empty($shipment->sizes)){
						$total = 0;
						foreach($shipment->sizes as $size){
							$sPrice = Functions::getPrice(json_decode($shipment->prices), $size->sizes_id, $shipment->colour_type, $shipment->colourways_id);
							if(!is_string($sPrice)){
								$total = $total + ($size->qty * $sPrice->cmt);
							}
						}
						$shipment->cmt_total = $total;
						$shipment->cmt_total_base = Conversions::convertCurrency($shipment->fact_currency, "£", $total, $season);
					}
					#QUOTE
					if(!empty($shipment->sizes)){
						$total = 0;
						foreach($shipment->sizes as $size){
							$sPrice = Functions::getPrice(json_decode($shipment->prices), $size->sizes_id, $shipment->colour_type, $shipment->colourways_id);
							if(!is_string($sPrice)){
								$total = $total + ($size->qty * $sPrice->quote);
							}
						}
						$shipment->quote_total = $total;
						$shipment->quote_total_base = Conversions::convertCurrency($shipment->cust_currency, "£", $total, $season);
						if($shipment->customer_factored){
							$shipment->quote_total_factor_amt = $shipment->quote_total * .8;
							$shipment->quote_total_factor_amt_base = Conversions::convertCurrency($shipment->cust_currency, "£", $shipment->quote_total, $season) * .8;
                        }
						else{
							$shipment->quote_total_factor_amt = 0;
                            $shipment->quote_total_factor_amt_base = 0;
                        }
						$shipment->remaining_factored = $shipment->quote_total - $shipment->quote_total_factor_amt;
                        // if($shipment->customer == 'Rowing Blazers EUROS')
                        //     dd($shipment->remaining_factored);

						$shipment->remaining_factored_base = $shipment->quote_total_base - $shipment->quote_total_factor_amt_base;
						$shipment->remaining_factored_week = Carbon::parse($shipment->revised_exfty)->addDays($shipment->customer_terms)->startOfWeek()->format('Y-m-d');
					}

				}
            }
            else{
                $shipment->quote = $price;
                $shipment->quote_status = NULL;
                $shipment->cmt = NULL;
                $shipment->cmt_status = NULL;

				if(array_sum(array_column(json_decode($shipment->shipped_sizes) ?? [], 'qty')) == 0){
					#CMT
					if(!empty($shipment->sizes)){
						$total = 0;
						foreach($shipment->sizes as $size){
							$sPrice = Functions::getPrice(json_decode($shipment->prices), $size->sizes_id, $shipment->colour_type, $shipment->colourways_id);
							if(!is_string($sPrice)){
								$total = $total + ($size->qty * $sPrice->cmt);
							}
						}
						$shipment->cmt_total = $total;
						$shipment->cmt_total_base = Conversions::convertCurrency($shipment->fact_currency, "£", $total, $season);
					}

					#QUOTE
					if(!empty($shipment->sizes)){
						$total = 0;
						foreach($shipment->sizes as $size){
							$sPrice = Functions::getPrice(json_decode($shipment->prices), $size->sizes_id, $shipment->colour_type, $shipment->colourways_id);
							if(!is_string($sPrice)){
								$total = $total + ($size->qty * $sPrice->quote);
							}
						}
						$shipment->quote_total = $total;
						$shipment->quote_total_base = Conversions::convertCurrency($shipment->cust_currency, "£", $total, $season);
						if($shipment->customer_factored){
							$shipment->quote_total_factor_amt = $shipment->quote_total * .8;
							$shipment->quote_total_factor_amt_base = Conversions::convertCurrency($shipment->cust_currency, "£", $shipment->quote_total, $season) * .8;
                        }
						else{
							$shipment->quote_total_factor_amt = 0;
                            $shipment->quote_total_factor_amt_base = 0;
                        }
						$shipment->remaining_factored = $shipment->quote_total - $shipment->quote_total_factor_amt;
						$shipment->remaining_factored_base = $shipment->quote_total_base - $shipment->quote_total_factor_amt_base;
						$shipment->remaining_factored_week = Carbon::parse($shipment->revised_exfty)->addDays($shipment->customer_terms)->startOfWeek()->format('Y-m-d');

					}
				}
				else{
					#CMT
					if(!empty(json_decode($shipment->shipped_sizes))){
						$total = 0;
						foreach(json_decode($shipment->shipped_sizes) as $size){
							$sPrice = Functions::getPrice(json_decode($shipment->prices), $size->sizes_id, $shipment->colour_type, $shipment->colourways_id);
							if(!is_string($sPrice)){
								$total = $total + ($size->qty * $sPrice->cmt);
							}
						}
						$shipment->cmt_total = $total;
						$shipment->cmt_total_base = Conversions::convertCurrency($shipment->fact_currency, "£", $total, $season);
					}

					#QUOTE
					if(!empty(json_decode($shipment->shipped_sizes))){
						$total = 0;
						foreach(json_decode($shipment->shipped_sizes) as $size){
							$sPrice = Functions::getPrice(json_decode($shipment->prices), $size->sizes_id, $shipment->colour_type, $shipment->colourways_id);
							if(!is_string($sPrice)){
								$total = $total + ($size->qty * $sPrice->quote);
							}
						}
						$shipment->quote_total = $total;
						$shipment->quote_total_base = Conversions::convertCurrency($shipment->cust_currency, "£", $total, $season);
						if($shipment->customer_factored){
							$shipment->quote_total_factor_amt = $shipment->quote_total * .8;
							$shipment->quote_total_factor_amt_base = Conversions::convertCurrency($shipment->cust_currency, "£", $shipment->quote_total, $season) * .8;
                        }
						else{
							$shipment->quote_total_factor_amt = 0;
                            $shipment->quote_total_factor_amt_base = 0;
                        }
						$shipment->remaining_factored = $shipment->quote_total - $shipment->quote_total_factor_amt;
						$shipment->remaining_factored_base = $shipment->quote_total_base - $shipment->quote_total_factor_amt_base;
						$shipment->remaining_factored_week = Carbon::parse($shipment->revised_exfty)->addDays($shipment->customer_terms)->startOfWeek()->format('Y-m-d');

					}
				}
                $shipment->transport_budget = NULL;
            }
        }
		return $shipments;
    }
}
