<?php

namespace App\Helper;

use Exception;
use Carbon\Carbon;
use App\Models\Seasons;
use Carbon\CarbonPeriod;
use Illuminate\Support\Facades\Gate;


class Functions
{


    private static function getPriceCount($prices, $all = FALSE){
        // if(Gate::check('asdasd')){
        //     dd($prices);
        // }
        if($all)
            $prices = $prices->where('sizes_id', 1)->whereNULL('colour_type')->whereNULL('colourways_id');
        if($prices->where('quote_status', 'confirmed')->count() == 1){
            return $prices->where('quote_status', 'confirmed')->first();
        }
        if($prices->where('quote_status', 'confirmed')->count() > 1){
            return 'Many Confirmed';
        }
        if($prices->count() == 1){
            return $prices->first();
        }
        if($prices->unique('quote')->count() == 1){
            return $prices->first();
        }
        else{
            return 'Many Prices';
        }
    }

    public static function sanitise($var){
        if(is_string($var)){
            $var = trim(strip_tags($var));
        }
        elseif(is_array($var)){
            array_walk_recursive(
                    $var,
                    function(&$string) {
                        if (is_string($string)) {
                            $string = trim(strip_tags($string));
                        }
                    }
                );
        }
        return $var;
    }




}
