<div>
    <div class="overflow-hidden border border-gray-200 dark:border-gray-700 rounded-lg">
        <table class="min-w-full divide-y divide-gray-200 dark:divide-gray-700">
            <thead class="bg-gray-50 dark:bg-gray-900/40">
                <tr>
                    <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Period</th>
                    <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Cardholder</th>
                    <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Account</th>
                    <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Matched</th>
                    <th class="px-4 py-2"></th>
                </tr>
            </thead>
            <tbody class="bg-white dark:bg-gray-800 divide-y divide-gray-200 dark:divide-gray-700">
                @forelse ($statements as $s)
                    <tr>
                        <td class="px-4 py-2 text-sm">{{ $s->period_start?->format('Y-m-d') }} → {{ $s->period_end?->format('Y-m-d') }}</td>
                        <td class="px-4 py-2 text-sm">{{ $s->cardholder_name }}</td>
                        <td class="px-4 py-2 text-sm">{{ $s->account_number_masked }}</td>
                        <td class="px-4 py-2 text-sm">{{ $s->matched_count ?? 0 }} / {{ $s->total_count ?? 0 }}</td>
                        <td class="px-4 py-2 text-right">
                            <button wire:click="select({{ $s->id }})" class="px-3 py-1.5 rounded-md bg-indigo-600 text-white text-sm">Review</button>
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="5" class="px-4 py-6 text-center text-sm text-gray-500">No statements found.</td>
                    </tr>
                @endforelse
            </tbody>
        </table>
    </div>
</div>


