<!doctype html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- CSRF Token -->
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <!-- SEO Meta Tags -->
    <title>@yield('meta_title', config('app.name', 'Yarn Store') . ' - Premium Quality Yarns')</title>
    <meta name="description" content="@yield('meta_description', 'Discover premium quality yarns at Yarn Store by Robert Todd Yarn. Shop our curated collections by season and category.')">
    <meta name="keywords" content="@yield('meta_keywords', 'yarn, knitting, wool, cotton, premium yarn, Robert Todd Yarn')">
    
    <!-- Open Graph Meta Tags -->
    <meta property="og:title" content="@yield('og_title', config('app.name', 'Yarn Store'))">
    <meta property="og:description" content="@yield('og_description', 'Premium quality yarns for all your knitting projects')">
    <meta property="og:image" content="@yield('og_image', asset('images/og-default.jpg'))">
    <meta property="og:url" content="{{ url()->current() }}">
    <meta property="og:type" content="website">
    
    <!-- Twitter Card Meta Tags -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="@yield('twitter_title', config('app.name', 'Yarn Store'))">
    <meta name="twitter:description" content="@yield('twitter_description', 'Premium quality yarns for all your knitting projects')">
    
    <!-- Canonical URL -->
    <link rel="canonical" href="{{ url()->current() }}">

    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="{{ asset('favicon.ico') }}">

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=inter:400,500,600,700|playfair-display:700" rel="stylesheet">

    <!-- Styles -->
    @vite(['resources/sass/app.scss', 'resources/js/app.js'])
    @livewireStyles
    
    <!-- Structured Data for SEO -->
    @php
    $__ld = [
        '@context' => 'https://schema.org',
        '@type' => 'Organization',
        'name' => 'Robert Todd Yarn',
        'alternateName' => 'Yarn Store',
        'url' => url('/'),
        'logo' => asset('images/logo.png'),
        'description' => 'Premium quality yarns for all your knitting and crochet projects',
    ];
    @endphp
    <script type="application/ld+json">
    {!! json_encode($__ld, JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE) !!}
    </script>
    
    @stack('head')
</head>
<body>
    <div id="app">
        <!-- Navigation -->
        <nav class="ys-navbar sticky-top">
            <div class="container">
                <div class="d-flex justify-content-between align-items-center">
                    <!-- Logo -->
                    <a href="{{ route('home') }}" class="d-flex align-items-center text-decoration-none">
                        <h1 class="h4 mb-0 fw-bold" style="color: var(--ys-primary);">
                            Yarn Store
                        </h1>
                    </a>

                    <!-- Mobile Menu Toggle -->
                    <button class="btn d-lg-none" type="button" data-bs-toggle="collapse" data-bs-target="#navbarContent">
                        <span class="navbar-toggler-icon"></span>
                    </button>

                    <!-- Desktop Navigation -->
                    <div class="collapse navbar-collapse" id="navbarContent">
                        <ul class="navbar-nav mx-auto d-none d-lg-flex gap-2">
                            <li class="nav-item">
                                <a class="ys-nav-link {{ request()->routeIs('home') ? 'active' : '' }}" href="{{ route('home') }}">Home</a>
                            </li>
                            <li class="nav-item dropdown">
                                <a class="ys-nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown">
                                    Collections
                                </a>
                                <ul class="dropdown-menu">
                                    <li><a class="dropdown-item" href="{{ route('collections') }}">All Collections</a></li>
                                    <li><hr class="dropdown-divider"></li>
                                    @foreach(\App\Models\Season::where('is_active', true)->orderBy('sort_order')->get() as $season)
                                        <li><a class="dropdown-item" href="{{ route('collections.season', $season->slug) }}">{{ $season->name }}</a></li>
                                    @endforeach
                                </ul>
                            </li>
                            <li class="nav-item dropdown">
                                <a class="ys-nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown">
                                    Categories
                                </a>
                                <ul class="dropdown-menu">
                                    @foreach(\App\Models\Category::where('is_active', true)->orderBy('sort_order')->get() as $category)
                                        <li><a class="dropdown-item" href="{{ route('category', $category->slug) }}">{{ $category->name }}</a></li>
                                    @endforeach
                                </ul>
                            </li>
                            <li class="nav-item dropdown">
                                <a class="ys-nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown">
                                    Resources
                                </a>
                                <ul class="dropdown-menu">
                                    <li><a class="dropdown-item" href="{{ route('about') }}">About Yarn</a></li>
                                    <li><a class="dropdown-item" href="{{ route('care-guide') }}">Care Guide</a></li>
                                    <li><a class="dropdown-item" href="{{ route('patterns') }}">Patterns & Projects</a></li>
                                    <li><hr class="dropdown-divider"></li>
                                    <li><a class="dropdown-item" href="{{ route('contact') }}">Contact Us</a></li>
                                </ul>
                            </li>
                        </ul>

                        <!-- Right Side Actions -->
                        <div class="d-flex align-items-center gap-3">
                            <!-- Search Toggle -->
                            <button class="btn btn-link p-0" type="button" data-bs-toggle="modal" data-bs-target="#searchModal">
                                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor" viewBox="0 0 16 16">
                                    <path d="M11.742 10.344a6.5 6.5 0 1 0-1.397 1.398h-.001c.03.04.062.078.098.115l3.85 3.85a1 1 0 0 0 1.415-1.414l-3.85-3.85a1.007 1.007 0 0 0-.115-.1zM12 6.5a5.5 5.5 0 1 1-11 0 5.5 5.5 0 0 1 11 0z"/>
                                </svg>
                            </button>

                            <!-- Account -->
                            @auth
                                <div class="dropdown">
                                    <a class="btn btn-link p-0 dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor" viewBox="0 0 16 16">
                                            <path d="M8 8a3 3 0 1 0 0-6 3 3 0 0 0 0 6zm2-3a2 2 0 1 1-4 0 2 2 0 0 1 4 0zm4 8c0 1-1 1-1 1H3s-1 0-1-1 1-4 6-4 6 3 6 4zm-1-.004c-.001-.246-.154-.986-.832-1.664C11.516 10.68 10.289 10 8 10c-2.29 0-3.516.68-4.168 1.332-.678.678-.83 1.418-.832 1.664h10z"/>
                                        </svg>
                                    </a>
                                    <ul class="dropdown-menu dropdown-menu-end">
                                        <li><a class="dropdown-item" href="{{ route('account.profile') }}">My Profile</a></li>
                                        <li><a class="dropdown-item" href="{{ route('account.orders') }}">My Orders</a></li>
                                        @if(Auth::user()->isAdmin())
                                            <li><hr class="dropdown-divider"></li>
                                            <li><a class="dropdown-item" href="{{ route('admin.dashboard') }}">Admin Panel</a></li>
                                        @endif
                                        <li><hr class="dropdown-divider"></li>
                                        <li>
                                            <a class="dropdown-item" href="{{ route('logout') }}"
                                               onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
                                                Logout
                                            </a>
                                        </li>
                                    </ul>
                                </div>
                                <form id="logout-form" action="{{ route('logout') }}" method="POST" class="d-none">
                                    @csrf
                                </form>
                            @endauth
                            @guest
                                <a href="{{ route('login') }}" class="btn btn-link p-0">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor" viewBox="0 0 16 16">
                                        <path d="M8 8a3 3 0 1 0 0-6 3 3 0 0 0 0 6zm2-3a2 2 0 1 1-4 0 2 2 0 0 1 4 0zm4 8c0 1-1 1-1 1H3s-1 0-1-1 1-4 6-4 6 3 6 4zm-1-.004c-.001-.246-.154-.986-.832-1.664C11.516 10.68 10.289 10 8 10c-2.29 0-3.516.68-4.168 1.332-.678.678-.83 1.418-.832 1.664h10z"/>
                                    </svg>
                                </a>
                            @endguest

                            <!-- Basket -->
                            <a href="{{ route('basket') }}" class="btn btn-link p-0 position-relative">
                                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor" viewBox="0 0 16 16">
                                    <path d="M0 1.5A.5.5 0 0 1 .5 1H2a.5.5 0 0 1 .485.379L2.89 3H14.5a.5.5 0 0 1 .491.592l-1.5 8A.5.5 0 0 1 13 12H4a.5.5 0 0 1-.491-.408L2.01 3.607 1.61 2H.5a.5.5 0 0 1-.5-.5zM3.102 4l1.313 7h8.17l1.313-7H3.102zM5 12a2 2 0 1 0 0 4 2 2 0 0 0 0-4zm7 0a2 2 0 1 0 0 4 2 2 0 0 0 0-4zm-7 1a1 1 0 1 1 0 2 1 1 0 0 1 0-2zm7 0a1 1 0 1 1 0 2 1 1 0 0 1 0-2z"/>
                                </svg>
                                @livewire('basket-count')
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </nav>

        <!-- Main Content -->
        <main>
            @yield('content')
        </main>

        <!-- Footer -->
        <footer class="ys-footer">
            <div class="container">
                <div class="row g-4">
                    <!-- About -->
                    <div class="col-lg-4">
                        <h5 class="fw-bold mb-3" style="color: var(--ys-primary);">Yarn Store</h5>
                        <p class="text-muted small">
                            Premium quality yarns by Robert Todd Yarn. Discover our curated collections for all your knitting and crochet projects.
                        </p>
                        <p class="text-muted small">
                            <strong>Registered Business:</strong> Robert Todd Yarn
                        </p>
                    </div>

                    <!-- Quick Links -->
                    <div class="col-lg-2 col-md-4 col-6">
                        <h6 class="fw-bold mb-3">Shop</h6>
                        <ul class="list-unstyled">
                            <li class="mb-2"><a href="{{ route('collections') }}" class="ys-footer-link small">Collections</a></li>
                            <li class="mb-2"><a href="{{ route('search') }}" class="ys-footer-link small">Search</a></li>
                            <li class="mb-2"><a href="{{ route('basket') }}" class="ys-footer-link small">Basket</a></li>
                        </ul>
                    </div>

                    <!-- Resources -->
                    <div class="col-lg-2 col-md-4 col-6">
                        <h6 class="fw-bold mb-3">Resources</h6>
                        <ul class="list-unstyled">
                            <li class="mb-2"><a href="{{ route('about') }}" class="ys-footer-link small">About Yarn</a></li>
                            <li class="mb-2"><a href="{{ route('care-guide') }}" class="ys-footer-link small">Care Guide</a></li>
                            <li class="mb-2"><a href="{{ route('patterns') }}" class="ys-footer-link small">Patterns</a></li>
                            <li class="mb-2"><a href="{{ route('contact') }}" class="ys-footer-link small">Contact</a></li>
                        </ul>
                    </div>

                    <!-- Legal -->
                    <div class="col-lg-2 col-md-4 col-6">
                        <h6 class="fw-bold mb-3">Legal</h6>
                        <ul class="list-unstyled">
                            <li class="mb-2"><a href="{{ route('terms') }}" class="ys-footer-link small">Terms & Conditions</a></li>
                            <li class="mb-2"><a href="{{ route('privacy') }}" class="ys-footer-link small">Privacy Policy</a></li>
                            <li class="mb-2"><a href="{{ route('cookies') }}" class="ys-footer-link small">Cookie Policy</a></li>
                        </ul>
                    </div>

                    <!-- Account -->
                    <div class="col-lg-2 col-md-4 col-6">
                        <h6 class="fw-bold mb-3">Account</h6>
                        <ul class="list-unstyled">
                            @auth
                                <li class="mb-2"><a href="{{ route('account.profile') }}" class="ys-footer-link small">My Profile</a></li>
                                <li class="mb-2"><a href="{{ route('account.orders') }}" class="ys-footer-link small">My Orders</a></li>
                            @endauth
                            @guest
                                <li class="mb-2"><a href="{{ route('login') }}" class="ys-footer-link small">Login</a></li>
                                <li class="mb-2"><a href="{{ route('register') }}" class="ys-footer-link small">Register</a></li>
                            @endguest
                        </ul>
                    </div>
                </div>

                <hr class="my-4" style="border-color: var(--ys-light-gray);">

                <div class="row align-items-center">
                    <div class="col-md-6 text-center text-md-start mb-3 mb-md-0">
                        <p class="text-muted small mb-0">
                            &copy; {{ date('Y') }} Robert Todd Yarn. All rights reserved.
                        </p>
                    </div>
                    <div class="col-md-6 text-center text-md-end">
                        <p class="text-muted small mb-0">
                            Made with care in the UK
                        </p>
                    </div>
                </div>
            </div>
        </footer>

        <!-- Cookie Consent -->
        @livewire('cookie-consent')
    </div>

    <!-- Search Modal -->
    <div class="modal fade" id="searchModal" tabindex="-1">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content">
                @livewire('search')
            </div>
        </div>
    </div>

    @livewireScripts
    @stack('scripts')
</body>
</html>

