<?php

namespace App\Livewire\Admin;

use App\Models\Season;
use Livewire\Component;
use Livewire\WithPagination;

class Seasons extends Component
{
    use WithPagination;
    
    public $search = '';
    public $statusFilter = '';
    public $perPage = 10;
    
    protected $queryString = [
        'search' => ['except' => ''],
        'statusFilter' => ['except' => ''],
        'perPage' => ['except' => 10],
    ];
    
    public function updatingSearch()
    {
        $this->resetPage();
    }
    
    public function updatingStatusFilter()
    {
        $this->resetPage();
    }

    public function viewSeason($seasonId)
    {
        return redirect()->route('admin.seasons.show', $seasonId);
    }
    
    public function render()
    {
        $seasons = Season::query()
            ->when($this->search, function ($query) {
                $query->where('name', 'like', '%' . $this->search . '%')
                      ->orWhere('description', 'like', '%' . $this->search . '%');
            })
            ->when($this->statusFilter, function ($query) {
                if ($this->statusFilter === 'active') {
                    $query->where('is_active', true);
                } elseif ($this->statusFilter === 'inactive') {
                    $query->where('is_active', false);
                } elseif ($this->statusFilter === 'current') {
                    $now = now()->toDateString();
                    $query->where('is_active', true)
                          ->where('start_date', '<=', $now)
                          ->where(function ($q) use ($now) {
                              $q->whereNull('end_date')
                                ->orWhere('end_date', '>=', $now);
                          });
                }
            })
            ->orderBy('sort_order')
            ->orderBy('name')
            ->paginate($this->perPage);
            
        return view('livewire.admin.seasons', [
            'seasons' => $seasons
        ])
            ->layout('layouts.admin')
            ->title('Seasons');
    }
}
