<?php

namespace App\Livewire;

use Livewire\Component;
use App\Models\Item;

class Search extends Component
{
    public $query = '';
    public $results = [];
    public $showResults = false;

    public function updatedQuery()
    {
        if (strlen($this->query) < 2) {
            $this->results = [];
            $this->showResults = false;
            return;
        }

        $this->results = Item::where('is_active', true)
            ->where(function ($q) {
                $q->where('name', 'LIKE', "%{$this->query}%")
                    ->orWhere('description', 'LIKE', "%{$this->query}%")
                    ->orWhere('sku', 'LIKE', "%{$this->query}%");
            })
            ->with(['season', 'category'])
            ->limit(5)
            ->get();

        $this->showResults = true;
    }

    public function selectResult($slug)
    {
        return redirect()->route('product', $slug);
    }

    public function viewAllResults()
    {
        return redirect()->route('search', ['q' => $this->query]);
    }

    public function render()
    {
        return view('livewire.search');
    }
}
