# 📋 Image Paste & Upload Guide

> **Implementation based on [StackOverflow's recommended solution](https://stackoverflow.com/questions/490908/paste-an-image-from-clipboard-using-javascript)** using `event.clipboardData.items` for maximum browser compatibility.

## How to Upload Images to Colourways

### Method 1: Paste Button (Easiest!)
1. Copy an image to your clipboard (screenshot, right-click → Copy Image, etc.)
2. Click the **"Paste"** button (📋 icon) on any colourway
3. Image uploads automatically!

**Works in:** Chrome, Firefox, Safari, Edge (all modern browsers)

For colourways without images:
- Click the blue **"Paste"** button in the center

For colourways with existing images:
- Click the blue **clipboard icon button** (📋) in the top-right corner

### Method 2: Choose File Button
1. Click the **"Choose"** button (📤 icon) on any colourway
2. Your file browser will open
3. Select an image file - it uploads automatically!

### Method 3: Keyboard Paste (Traditional)
1. Copy an image to your clipboard
2. Click on any colourway card to focus it
3. Press **`Ctrl+V`** (Windows/Linux) or **`⌘V`** (Mac)
4. Image uploads automatically!

### Method 4: Drag & Drop
- Drag an image file from your computer's file explorer onto any colourway card
- Drag an image directly from a web page (Chrome, Firefox, Safari) onto a card
- The card will highlight in blue when you're hovering over it

## How to Paste Images into Item Images

### Click + Paste
1. **Click in the upload area** (where it says "Click here")
2. The area will highlight with a blue border and glow
3. **Press `Ctrl+V`** or **`⌘V`** to paste
4. Paste multiple times to add multiple images!

### Drag & Drop
- Drag one or more image files from your computer
- Drag images from web pages
- Supports multiple images at once

## What Types of Images Can You Paste?

✅ **Screenshots** - Take a screenshot and paste immediately  
✅ **Copied images from web pages** - Right-click an image → Copy → Paste  
✅ **Images from other apps** - Copy from Photoshop, Figma, etc.  
✅ **Images dragged from web pages** - Works with most modern browsers  
✅ **File drag & drop** - From Windows Explorer, Mac Finder, etc.  

## Visual Indicators

| State | What You'll See |
|-------|-----------------|
| **Ready to accept paste** | Blue border + blue glow + tooltip |
| **Dragging over** | Blue border + light blue background |
| **Uploading** | Console shows progress percentage |
| **Success** | Image appears immediately |

## Tips

- You must be in **Edit Mode** for upload buttons to appear
- **Use the button method** - it's the most straightforward!
- Each colourway card accepts one image at a time
- The Item Images area accepts multiple images
- If an image fails to load from a URL, you'll get a helpful error message
- Check your browser console (F12) for detailed upload progress

## Keyboard Shortcuts

- **`Ctrl+V`** / **`⌘V`** - Paste image from clipboard (after clicking a card)
- **`Tab`** - Navigate between colourway cards
- **`Enter`** - Focus the currently selected card (then paste)

---

## Quick Reference

| Action | How To |
|--------|--------|
| **Paste from clipboard** | Click the blue "Paste" button (📋) |
| **Upload a file** | Click the "Choose" button (📤) |
| **Replace existing image** | Click clipboard (📋) or upload (📤) icon on image |
| **Keyboard paste** | Click card → Press Ctrl+V / ⌘V |
| **Drag from files** | Drag file onto any colourway card |
| **Drag from web** | Drag image from browser onto card |

**Need help?** Make sure you:
1. Are in **Edit Mode** (click the "Edit Item" button)
2. Have an image in your clipboard (for paste)
3. Check the browser console (F12) for detailed debugging info

## Browser Compatibility

This implementation uses the standard `paste` event with `event.clipboardData.items` method, which is supported in:

- ✅ **Chrome/Edge** - Full support
- ✅ **Firefox** - Full support  
- ✅ **Safari** - Full support (13.1+)
- ✅ **Opera** - Full support

The implementation follows the [recommended approach from StackOverflow](https://stackoverflow.com/questions/490908/paste-an-image-from-clipboard-using-javascript) which has been proven to work in production apps like Gmail and Imgur.

**No browser permissions required** - the paste event is triggered naturally by the user's action.

