# 📋 Image Paste & Upload Guide

## How to Upload Images to Colourways

### Method 1: Use the Button (Easiest!)
1. Look for the **"Choose or Paste"** button on any colourway without an image
2. **Click the button** - your file browser will open
3. **Select an image file** - it uploads automatically!

For colourways that already have an image:
- Look for the **upload icon button** in the top-right corner of the image
- Click it to replace the image

### Method 2: Click + Paste
1. **Click on any colourway card** - you'll see it highlight with a blue border
2. A tooltip will appear saying "Ready to paste! Press Ctrl+V (⌘V on Mac)"
3. **Press `Ctrl+V`** (Windows/Linux) or **`⌘V`** (Mac)
4. Your image will automatically upload!

### Method 3: Drag & Drop
- Drag an image file from your computer's file explorer onto any colourway card
- Drag an image directly from a web page (Chrome, Firefox, Safari) onto a card
- The card will highlight in blue when you're hovering over it

## How to Paste Images into Item Images

### Click + Paste
1. **Click in the upload area** (where it says "Click here")
2. The area will highlight with a blue border and glow
3. **Press `Ctrl+V`** or **`⌘V`** to paste
4. Paste multiple times to add multiple images!

### Drag & Drop
- Drag one or more image files from your computer
- Drag images from web pages
- Supports multiple images at once

## What Types of Images Can You Paste?

✅ **Screenshots** - Take a screenshot and paste immediately  
✅ **Copied images from web pages** - Right-click an image → Copy → Paste  
✅ **Images from other apps** - Copy from Photoshop, Figma, etc.  
✅ **Images dragged from web pages** - Works with most modern browsers  
✅ **File drag & drop** - From Windows Explorer, Mac Finder, etc.  

## Visual Indicators

| State | What You'll See |
|-------|-----------------|
| **Ready to accept paste** | Blue border + blue glow + tooltip |
| **Dragging over** | Blue border + light blue background |
| **Uploading** | Console shows progress percentage |
| **Success** | Image appears immediately |

## Tips

- You must be in **Edit Mode** for paste/drag to work
- Each colourway card accepts one image at a time
- The Item Images area accepts multiple images
- If an image fails to load from a URL, you'll get a helpful error message
- Check your browser console (F12) for detailed upload progress

## Keyboard Shortcuts

- **`Ctrl+V`** / **`⌘V`** - Paste image from clipboard
- **`Tab`** - Navigate between colourway cards
- **`Enter`** - Focus the currently selected card (then paste)

---

**Need help?** Make sure you:
1. Click on the card/area first
2. Have an image in your clipboard
3. Are in Edit Mode

