<li class="dropdown">
    <a role="button" class="dropdown-button ps-4 p-2 mb-2 text-decoration-none d-flex align-items-center cursor-pointer text-white {{ (in_array(request()->segment(1), $sub_links)) ? 'bg-secondary' : '' }}" id="dropdown-{{strtolower($dropdownName)}}-btn">
        <span class="fw-semibold">
        @if($dropdownName == 'Development')
            <i class="fas fa-code text-white" style="width: 20px; height: 20px;"></i>
        @elseif($dropdownName == 'Sales')
            <i class="fas fa-chart-line text-white" style="width: 20px; height: 20px;"></i>
        @elseif($dropdownName == 'Production')
            <i class="fas fa-industry text-white" style="width: 20px; height: 20px;"></i>
        @elseif($dropdownName == 'Finance')
            <i class="fas fa-dollar-sign text-white" style="width: 20px; height: 20px;"></i>
        @elseif($dropdownName == 'Tools')
            <i class="fas fa-tools text-white" style="width: 20px; height: 20px;"></i>
        @elseif($dropdownName == 'Import')
            <i class="fas fa-upload text-white" style="width: 20px; height: 20px;"></i>
        @elseif($dropdownName == 'Management')
            <i class="fas fa-users-cog text-white" style="width: 20px; height: 20px;"></i>
        @else
            <i class="fas fa-folder text-white" style="width: 20px; height: 20px;"></i>
        @endif
        <span class="ms-3" id="{{strtolower($dropdownName)}}-down">{{$dropdownName}} &nbsp;&nbsp;<i class="fa-solid fa-angle-down text-white"></i></span>
        <span class="ms-3" id="{{strtolower($dropdownName)}}-up" style="display: none;">{{$dropdownName}} &nbsp;&nbsp;<i class="fa-solid fa-angle-up text-white"></i></span>
        </span>
    </a>
    <ul id="dropdown-{{strtolower($dropdownName)}}" class="dropdown-header list-unstyled mb-3" style="display: none;">
        @foreach ($sub_headings as $h=>$heading)
            <li class="ms-5">
                <a class="px-4 py-2 text-decoration-none d-flex align-items-center cursor-pointer text-white {{ request()->segment(1) == $heading ? 'bg-secondary' : '' }} " href="{{route($heading)}}">
                    <span class="fw-semibold">{{ucfirst(trans($h))}}</span>
                </a>
            </li>
        @endforeach
        @foreach ($tertiary ?? [] as $i=>$headings)
            <li class="ms-5">
                <div class="dropdown-button dropup btn-group w-100">
                    <span role="button" class="px-4 py-2 text-decoration-none d-flex align-items-center cursor-pointer text-white w-100 {{ (in_array(request()->segment(1), array_values($headings))) ? 'bg-secondary' : '' }}" data-bs-toggle="dropdown" aria-expanded="false">
                        <span class="fw-semibold">{{ucfirst(trans($i))}}<i class="ms-2 fa-solid fa-angle-right text-white"></i></span>
                    </span>
                    <ul class="dropdown-menu bg-primary border-0 text-white p-0" style="left: 200px;    margin-bottom: -38px;">
                        @foreach($headings as $h=>$heading)
                            <li class="">
                                <a class="p-2 text-decoration-none d-flex align-items-center gap-2 cursor-pointer text-white {{ (request()->segment(1) == $heading) ? 'bg-secondary' : '' }}" href="{{ route($heading) }}">
                                    <span class="fw-semibold">
                                        <span class="ms-3">{{$h}}</span>
                                    </span>
                                </a>
                            </li>
                        @endforeach
                    </ul>
                </div>
            </li>
        @endforeach
    </ul>
</li>
@script
    <script>
            handleDropdown("dropdown-{{strtolower($dropdownName)}}-btn", "dropdown-{{strtolower($dropdownName)}}", "{{strtolower($dropdownName)}}-down", "{{strtolower($dropdownName)}}-up", $wire.sub_links);
    </script>
@endscript
