<div>
    <style>
        .cursor-pointer {
            cursor: pointer;
        }
        .cursor-pointer:hover {
            background-color: var(--bs-gray-50);
        }
        [data-bs-theme="dark"] .cursor-pointer:hover {
            background-color: var(--bs-gray-800);
        }
    </style>
    
    <!-- Header -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h1 class="h3 mb-1">Categories</h1>
            <p class="text-muted mb-0">Organize your products into categories</p>
        </div>
        <button class="btn btn-primary">
            <i class="bi bi-plus-lg me-2"></i>Add Category
        </button>
    </div>

    <!-- Filters -->
    <div class="card mb-4">
        <div class="card-body">
            <div class="row g-3">
                <div class="col-md-4">
                    <label class="form-label">Search Categories</label>
                    <div class="input-group">
                        <span class="input-group-text">
                            <i class="bi bi-search"></i>
                        </span>
                        <input type="text" 
                               wire:model.live.debounce.300ms="search" 
                               class="form-control" 
                               placeholder="Search by name or description...">
                    </div>
                </div>
                
                <div class="col-md-3">
                    <label class="form-label">Status</label>
                    <select wire:model.live="statusFilter" class="form-select">
                        <option value="">All Categories</option>
                        <option value="active">Active Only</option>
                        <option value="inactive">Inactive Only</option>
                    </select>
                </div>
                
                <div class="col-md-2">
                    <label class="form-label">Per Page</label>
                    <select wire:model.live="perPage" class="form-select">
                        <option value="5">5</option>
                        <option value="10">10</option>
                        <option value="25">25</option>
                        <option value="50">50</option>
                    </select>
                </div>
                
                <div class="col-md-3 d-flex align-items-end">
                    @if($search || $statusFilter)
                        <button wire:click="$set('search', ''); $set('statusFilter', '')" 
                                class="btn btn-outline-secondary">
                            <i class="bi bi-x-lg me-2"></i>Clear Filters
                        </button>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <!-- Categories Table -->
    <div class="card">
        <div class="card-body p-0">
            @if($categories->count() > 0)
                <div class="table-responsive">
                    <table class="table table-hover mb-0">
                        <thead class="table-light">
                            <tr>
                                <th class="border-0">Category</th>
                                <th class="border-0">Description</th>
                                <th class="border-0">Items</th>
                                <th class="border-0">Status</th>
                                <th class="border-0">Sort Order</th>
                                <th class="border-0 text-end">Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($categories as $category)
                                <tr class="cursor-pointer" wire:click="viewCategory({{ $category->id }})">
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <div class="me-3">
                                                <div class="bg-primary bg-opacity-10 rounded d-flex align-items-center justify-content-center" 
                                                     style="width: 40px; height: 40px;">
                                                    <i class="bi bi-tags text-primary"></i>
                                                </div>
                                            </div>
                                            <div>
                                                <div class="fw-semibold">{{ $category->name }}</div>
                                                <div class="small text-muted">{{ $category->slug }}</div>
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="text-body">
                                            {{ $category->description ? Str::limit($category->description, 50) : 'No description' }}
                                        </div>
                                    </td>
                                    <td>
                                        <div class="small">{{ $category->items_count ?? 0 }} items</div>
                                    </td>
                                    <td>
                                        @if($category->is_active)
                                            <span class="badge bg-success">
                                                <i class="bi bi-check-circle me-1"></i>Active
                                            </span>
                                        @else
                                            <span class="badge bg-secondary">
                                                <i class="bi bi-pause-circle me-1"></i>Inactive
                                            </span>
                                        @endif
                                    </td>
                                    <td>
                                        <span class="badge bg-light text-dark">{{ $category->sort_order }}</span>
                                    </td>
                                    <td class="text-end">
                                        <div class="btn-group btn-group-sm">
                                            <a href="{{ route('admin.categories.show', $category->id) }}" 
                                               class="btn btn-outline-primary">
                                                <i class="bi bi-eye"></i>
                                            </a>
                                            <a href="{{ route('admin.categories.show', $category->id) }}" 
                                               class="btn btn-outline-secondary">
                                                <i class="bi bi-pencil"></i>
                                            </a>
                                            <button class="btn btn-outline-danger">
                                                <i class="bi bi-trash"></i>
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
                
                <!-- Pagination -->
                <div class="d-flex justify-content-between align-items-center p-3 border-top">
                    <div class="text-muted small">
                        Showing {{ $categories->firstItem() }} to {{ $categories->lastItem() }} 
                        of {{ $categories->total() }} categories
                    </div>
                    <div>
                        {{ $categories->links() }}
                    </div>
                </div>
            @else
                <!-- Empty State -->
                <div class="text-center py-5">
                    <i class="bi bi-tags display-1 text-muted"></i>
                    <h4 class="mt-3">No categories found</h4>
                    <p class="text-muted">
                        @if($search || $statusFilter)
                            No categories match your current filters.
                        @else
                            Get started by creating your first category.
                        @endif
                    </p>
                    @if($search || $statusFilter)
                        <button wire:click="$set('search', ''); $set('statusFilter', '')" 
                                class="btn btn-outline-primary">
                            <i class="bi bi-arrow-clockwise me-2"></i>Clear Filters
                        </button>
                    @else
                        <button class="btn btn-primary">
                            <i class="bi bi-plus-lg me-2"></i>Add Category
                        </button>
                    @endif
                </div>
            @endif
        </div>
    </div>
</div>