<?php
$meta = [
  'title' => 'Sage → Zoho Books Migration | Case Study',
  'description' => 'Planned and managed a finance system migration to Zoho Books, improving visibility and adaptability.',
  'canonical' => 'https://neilwiddowson.co.uk/portfolio/finance-migration-zoho.php'
];
$currentPage = 'portfolio';
include __DIR__.'/../includes/header.php';
?>

<main id="main-content" class="section">
  <div class="container max-w-4xl">
    <h1 class="text-3xl font-bold tracking-tight">Sage → Zoho Books Migration</h1>
    <p class="mt-2 text-sm text-gray-600">Lead Software Developer — finance ops improvement</p>

    <div class="mt-6 grid gap-6 md:grid-cols-2">
      <div class="card p-4">
        <h2 class="font-semibold text-gray-900">Role</h2>
        <p class="mt-2 text-sm text-gray-700">Consulted with directors and finance team, mapped data, planned the migration path and training.</p>
      </div>
      <div class="card p-4">
        <h2 class="font-semibold text-gray-900">Outcome</h2>
        <p class="mt-2 text-sm text-gray-700">Smoother daily operations, clearer reporting, and easier adaptation to business change.</p>
      </div>
    </div>

    <div class="mt-6">
      <a href="/portfolio/" class="btn-secondary">Back to portfolio</a>
    </div>
  </div>
</main>

<?php include __DIR__.'/../includes/footer.php'; ?>


