<?php
$meta = [
  'title' => 'FAQs | Practical answers',
  'description' => 'Timelines, what I need from you, ongoing support, ownership, and moving from WordPress/Wix to Joomla.',
  'canonical' => 'https://neilwiddowson.co.uk/faqs/'
];
$currentPage = 'faqs';
include __DIR__.'/../includes/header.php';
?>

<main id="main-content" class="section">
  <div class="container max-w-3xl">
    <h1 class="text-3xl font-bold tracking-tight">FAQs</h1>
    <dl class="mt-6 space-y-6">
      <div class="card p-5">
        <dt class="font-medium text-gray-900">How long does a typical website take?</dt>
        <dd class="mt-2 text-gray-700 text-sm">Most small business sites take 2–4 weeks once we have your content. I keep things simple and communicate clearly at each step.</dd>
      </div>
      <div class="card p-5">
        <dt class="font-medium text-gray-900">Do you work with WordPress or Wix?</dt>
        <dd class="mt-2 text-gray-700 text-sm">Yes. I specialise in Joomla, but I'm happy to migrate and support sites moving from WordPress or Wix.</dd>
      </div>
      <div class="card p-5">
        <dt class="font-medium text-gray-900">What happens after launch?</dt>
        <dd class="mt-2 text-gray-700 text-sm">I offer care plans to handle updates, backups, and security, plus small content tweaks to keep your site fresh.</dd>
      </div>
      <div class="card p-5">
        <dt class="font-medium text-gray-900">Who owns the website?</dt>
        <dd class="mt-2 text-gray-700 text-sm">You do. You'll have admin access and full control. I provide training so you can update content confidently.</dd>
      </div>
    </dl>
  </div>
</main>

<?php include __DIR__.'/../includes/footer.php'; ?>
