<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('receipts', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained('users')->cascadeOnDelete();
            $table->date('receipt_date')->index();
            $table->string('merchant_name')->nullable();
            $table->decimal('total_amount', 12, 2);
            $table->string('currency', 3)->default('GBP');
            $table->string('image_disk')->nullable();
            $table->string('image_path')->nullable();
            $table->string('image_hash', 128)->nullable()->index();
            $table->foreignId('department_id')->nullable()->constrained('departments')->nullOnDelete();
            $table->foreignId('account_id')->nullable()->constrained('accounts')->nullOnDelete();
            $table->boolean('is_personal')->default(false)->index();
            $table->json('meta')->nullable();
            $table->timestamps();
            $table->index(['receipt_date', 'total_amount'], 'receipt_match_search_idx');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('receipts');
    }
};
