<?php

namespace App\Models;

use DateTime;
use App\Models\Sizes;
use App\Casts\TitleCase;
use App\Models\BaseModel;
use App\Helper\Conversions;
use \Bkwld\Cloner\Cloneable;
use Illuminate\Support\Facades\Gate;
use Illuminate\Support\Facades\Cache;
use App\Exceptions\DependencyException;
use OwenIt\Auditing\Contracts\Auditable;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Casts\Attribute;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class StyleVersions extends BaseModel implements Auditable
{
    use \OwenIt\Auditing\Auditable;
    use SoftDeletes;
    use HasFactory;
    use Cloneable;

    public static function boot()
    {
        parent::boot();

        static::deleting(function($model) {
            $model->colourways?->each?->delete();
            $model->prices?->each?->delete();
        });
        static::restoring(function($model) {
            $model->colourways()->withTrashed()->where('deleted_at', '>=', $model->deleted_at)->each(function ($item, $key) { $item->restore(); });
            $model->prices()->withTrashed()->where('deleted_at', '>=', $model->deleted_at)->each(function ($item, $key) { $item->restore(); });
        });
    }

    protected static function booted()
    {
        static::saved(function ($styleVersion) {
            if ($styleVersion->isDirty(['factory_id', 'gauge_id', 'yarn_ends'])) {
                $seasonId = $styleVersion->styles?->seasons_id;
                
                $cacheTags = ['prices', 'styleversion:' . $styleVersion->id];
                if ($seasonId) {
                    $cacheTags[] = 'season:' . $seasonId;
                }
                
                Cache::tags($cacheTags)->flush();
            }
            self::invalidatePriceResolutions($styleVersion);
        });

        static::deleted(function ($styleVersion) {
            self::invalidatePriceResolutions($styleVersion);
        });
    }

    protected $cloneable_relations = [
        'colourways',
    ];

    protected $casts = [
        'name'       => TitleCase::class,
        'yarn_ends'  => 'integer',
        'issued'     => 'datetime:Y-m-d',
        'created_at' => 'datetime:Y-m-d',
        'updated_at' => 'datetime:Y-m-d',
        'deleted_at' => 'datetime:Y-m-d',
        'sample_yarn_date' => 'datetime:Y-m-d',
        'sample_accessories_date' => 'datetime:Y-m-d',
    ];

	protected $fillable = [
        'styles_id',
        'factory_id',
        'name',
        'gauge_id',
        'created_at',
        'updated_at',
        'yarn_ends',
        'issued',
        'deleted_at',
        'sample_yarn',
        'sample_yarn_date',
        'sample_accessories',
        'sample_accessories_date',
        'comments'
    ];

    // public function sampleDetails($sampleType){
    //     // return $this->styles->customers->setting('samples-charge')[7];
    //     if($this->cancelled){
    //         return NULL;
    //     }
    //     elseif(($sampleType == 1 || $sampleType == 2 || $sampleType == 3 || $sampleType == 4) && $this->styles->carryover == TRUE){
    //         return NULL;
    //     }
    //     elseif($this->samples->where('sample_types_id', $sampleType)->where('accepted', TRUE)->isEmpty() != TRUE){
    //         return 'Approved';
    //     }
    //     elseif($this->samples->where('sample_types_id', $sampleType)->isEmpty() != TRUE){
    //         if($this->samples->sortBy('created_at')->first()->date_sent == NULL)
    //             return 'Expected ' . date_format(new DateTime($this->samples->where('sample_types_id', $sampleType)->sortBy('created_at')->first()->date_expected), 'd-M');
    //         else
    //             return 'Sent To Customer ' . date_format(new DateTime($this->samples->where('sample_types_id', $sampleType)->sortBy('created_at')->first()->date_sent), 'd-M');
    //     }
    //     else{
    //         if(array_key_exists($sampleType, $this->styles->customers->setting('samples-charge')) && array_key_exists('required', $this->styles->customers->setting('samples-charge')[$sampleType]) && $this->styles->customers->setting('samples-charge')[$sampleType]['required'] == TRUE)
    //             return 'Required';
    //     }
    // }

    public function getImageAttribute(){
        // dd($this);
        if($this->colourways->whereNotNull('image')->first() != NULL)
            return url(asset('storage/' . $this->colourways->whereNotNull('image')->first()->image));
    }


    // public function getQuote($size = 32, $colourType = '', $colourway = ''){
    //     $currency = $this->styles->customers->currency;
    //     if($size != 32 && !empty($colourType) && !empty($colourway)){
    //         $prices = $this->prices->where('sizes_id', $size)->where('colour_type', $colourType)->where('colourways_id', $colourway);
    //         if($prices->count() != 0)
    //             return $this->getQuoteNewCount($currency, $prices);
    //     }
    //     if($size != 32 && !empty($colourway)){
    //         $prices = $this->prices->where('sizes_id', $size)->where('colourways_id', $colourway);
    //         if($prices->count() != 0)
    //             return $this->getQuoteNewCount($currency, $prices);
    //         }
    //     if($size != 32 && !empty($colourType)){
    //         $prices = $this->prices->where('sizes_id', $size)->where('colour_type', $colourType);
    //         if($prices->count() != 0)
    //             return $this->getQuoteNewCount($currency, $prices);
    //         }
    //     if($size != 32){
    //         $prices = $this->prices->where('sizes_id', $size);
    //         if($prices->count() != 0)
    //             return $this->getQuoteNewCount($currency, $prices);
    //         }
    //     if(!empty($colourType) && !empty($colourway)){
    //         $prices = $this->prices->where('colour_type', $colourType)->where('colourways_id', $colourway);
    //         if($prices->count() != 0)
    //             return $this->getQuoteNewCount($currency, $prices);
    //         }
    //     if(!empty($colourway)){
    //         $prices = $this->prices->where('colourways_id', $colourway);
    //         if($prices->count() != 0)
    //             return $this->getQuoteNewCount($currency, $prices);
    //         }
    //     if(!empty($colourType)){
    //         $prices = $this->prices->where('colour_type', $colourType);
    //         if($prices->count() != 0)
    //             return $this->getQuoteNewCount($currency, $prices);
    //         }
    //     $prices = $this->prices;
    //     if($prices->count() != 0)
    //         return $this->getQuoteNewCount($currency, $prices, TRUE);
    //     return ['Many Prices', FALSE];
    // }
































    // public function quote($currency){
    //     $return = [];
    //     if($this->prices->where('sizes_id', 32)->where('quote_agreed', '=', TRUE)->count() == 1){
    //         return [$this->prices->sortBy('updated_at')->where('sizes_id', 32)->where('quote_agreed', '=', TRUE)->first()->quoteCurrency('£')];
    //     }
    //     foreach($this->prices->where('sizes_id', 32) as $price){
    //         $return[] = $price->quoteCurrency($currency);
    //     }
    //     return $return;
    // }

    // public function acceptedQuote($currency){
    //     if($this->prices->where('quote_agreed', '=', TRUE)->count() == 1){
    //         return [$this->prices->where('quote_agreed', '=', TRUE)->first()->quoteCurrency('£')];
    //     }
    //     else
    //         return 'Not Agreed';
    // }

    // public function quoteStatus(){
    //     if($this->prices->where('quote_agreed', '=', TRUE)->count() == 0)
    //         return 'Not Accepted';
    //     elseif($this->prices->where('quote_agreed', '=', TRUE)->count() == 1)
    //         return 'Confirmed';
    //     else
    //         return 'Error - Multiple prices accepted';
    // }
    public function cmt(){
        // Try to get CMT from price resolution cache first
        $priceResolution = \App\Models\PriceResolution::where('style_versions_id', $this->id)
            ->whereNull('colourways_id')
            ->whereNull('sizes_id')
            ->whereNull('phase_id')
            ->whereNotNull('cmt')
            ->first();
            
        if ($priceResolution) {
            return $priceResolution->cmt;
        }
        
        // Fallback to old method if no price resolution
        if($this->prices->where('cmt_status', '=', 'confirmed')->count() == 1){
            return $this->prices->sortBy('updated_at')->where('cmt_status', '=', 'confirmed')->first()->cmt;
        }
        else{
            $priceLast = 'NA';
            foreach($this->prices as $price){
                if($priceLast == 'NA')
                    $priceLast = $price->cmt;
                elseif($priceLast != $price->cmt)
                    return 'Many';
            }
            return $priceLast;
        }
    }
    public function cmt_if_confirmed(){
        if($this->prices->where('cmt_status', '=', 'confirmed')->count() == 1){
            return $this->prices->sortBy('updated_at')->where('cmt_status', '=', 'confirmed')->first()->cmt;
        }
    }
    // public function cost($currency){
    //     if($this->prices->where('cmt_agreed', '=', TRUE)->count() == 1){
    //         return $this->prices->sortBy('updated_at')->where('cmt_agreed', '=', TRUE)->first()->gmtCostCustoms($currency);
    //     }
    //     else{
    //         $priceLast = 'NA';
    //         foreach($this->prices as $price){
    //             if($priceLast == 'NA')
    //                 $priceLast = $price->gmtCostCustoms($currency);
    //             elseif($priceLast != $price->gmtCostCustoms($currency))
    //                 return 'Many';
    //         }
    //         return $priceLast;
    //     }
    // }
    // public function margin(){
    //     if($this->prices->where('cmt_agreed', '=', TRUE)->where('quote_agreed', '=', TRUE)->count() == 1){
    //         return $this->prices->sortBy('updated_at')->where('cmt_agreed', '=', TRUE)->where('quote_agreed', '=', TRUE)->first()->margin();
    //     }
    //     else{
    //         $priceLast = 'NA';
    //         foreach($this->prices as $price){
    //             if($priceLast == 'NA')
    //                 $priceLast = $price->margin();
    //             elseif($priceLast != $price->margin())
    //                 return 'Many';
    //         }
    //         return $priceLast;
    //     }
    // }
    // public function cmtStatus(){
    //     if($this->prices->where('cmt_agreed', '=', TRUE)->count() == 0)
    //         if($this->prices->count() > 1)
    //             return 'Many';
    //         else
    //             return 'Not Accepted';
    //     elseif($this->prices->where('cmt_agreed', '=', TRUE)->count() == 1)
    //         return 'Confirmed';
    //     else
    //         return 'Error - Multiple cmt accepted';
    // }



    // protected function CostedWeightPercentage(): Attribute
    // {
    //     return Attribute::make(
    //         get: fn ($value) => number_format($value, 0, '.', ''),
    //         set: fn ($value) => empty($value) ? NULL : $value,
    //     );
    // }
    // protected function EstWeight(): Attribute
    // {
    //     return Attribute::make(
    //         get: fn ($value) => number_format($value, 2, '.', ''),
    //         set: fn ($value) => empty($value) ? NULL : $value,
    //     );
    // }
    // protected function AreaOfficeCommission(): Attribute
    // {
    //     return Attribute::make(
    //         get: fn ($value) => number_format($value, 2, '.', ''),
    //         set: fn ($value) => empty($value) ? NULL : $value,
    //     );
    // }
    // protected function YarnTransportationCost(): Attribute
    // {
    //     return Attribute::make(
    //         get: fn ($value) => number_format($value, 2, '.', ''),
    //         set: fn ($value) => empty($value) ? NULL : $value,
    //     );
    // }
    // protected function TransportCost(): Attribute
    // {
    //     return Attribute::make(
    //         get: fn ($value) => number_format($value, 2, '.', ''),
    //         set: fn ($value) => empty($value) ? NULL : $value,
    //     );
    // }

    // protected function CustomsCost(): Attribute
    // {
    //     return Attribute::make(
    //         get: fn ($value) => number_format($value, 2, '.', ''),
    //         set: fn ($value) => empty($value) ? NULL : $value,
    //     );
    // }
    // protected function OtherCosts(): Attribute
    // {
    //     return Attribute::make(
    //         get: fn ($value) => number_format($value, 2, '.', ''),
    //         set: fn ($value) => empty($value) ? NULL : $value,
    //     );
    // }

    // public function saveWithUser(){
    //     $this->last_updated_by = auth()->user()->id;
    //     $this->save();
    // }

    // public function sealerSampleApproved(){
    //     return TRUE;
    // }

    // public function ssSampleApproved(){
    //     return FALSE;
    // }
    public function styles()
    {
        return $this->belongsTo(Styles::class);
    }
    public function gauges()
    {
        return $this->belongsTo(Gauge::class, 'gauge_id');
    }
    public function factories()
    {
        return $this->belongsTo(Suppliers::class, 'factory_id');
    }

    public function prices()
    {
        return $this->hasMany(Price::class)
            ->orderBy(
                // A correlated subquery that fetches sizes.order
                Sizes::select('order')
                    ->whereColumn('sizes.id', 'prices.sizes_id')
            );
    }
	// public function samples()
    // {
    //     return $this->hasMany(Samples::class);
    // }
	public function colourways()
    {
        return $this->hasMany(Colourways::class);
    }


    // public function yarnCost($currencyOut){
    //     if(!$this->colourways->isEmpty()){
	// 		$cost = 0;
	// 		foreach($this->colourways as $i=>$colourway){
	// 			$colourwayCost = 0;
	// 			foreach($colourway->colourway_yarns as $yarn){
    //                 if(($this->pricing_model == 'full_factored' && $yarn->not_full_factored == TRUE) || $this->pricing_model == 'standard')
	// 				    $colourwayCost = $colourwayCost + Conversions::convertCurrency($yarn->yarns->suppliers->currency, '£', $yarn->price * ($yarn->percentage/100), $this->styles->seasons);
	// 			}
	// 			$cost = $cost + $colourwayCost;
	// 		}
	// 		$cost = $cost / $this->colourways->count();
    //         switch($currencyOut){
    //             case '£':
    //                 return number_format((float)$cost, 2, '.', '');
    //             case '€':
    //                 return number_format((float)Conversions::convertCurrency('£', '€', $cost, $this->styles->seasons), 2, '.', '');
    //             case '$':
    //                 return number_format((float)Conversions::convertCurrency('£', '$', $cost, $this->styles->seasons), 2, '.', '');
    //         }

	// 	}
	// 	else
	// 		return 0;
    // }

    // public function yarnCostGmt($currencyOut){
    //     $cost = $this->yarnCost('£') * $this->weightAccepted();

    //     switch($currencyOut){
    //         case '£':
    //             return number_format((float)$cost, 2, '.', '');
    //         case '€':
    //             return number_format((float)Conversions::convertCurrency('£', '€', $cost, $this->styles->seasons), 2, '.', '');
    //         case '$':
    //             return number_format((float)Conversions::convertCurrency('£', '$', $cost, $this->styles->seasons), 2, '.', '');
    //     }
    // }

    // public function fabricCost($currencyOut){
    //     if(!$this->colourways->isEmpty()){
	// 		$cost = 0;
	// 		foreach($this->colourways as $i=>$colourway){
	// 			$colourwayCost = 0;
	// 			foreach($colourway->colourway_fabrics as $fabric){
    //                 if(($this->pricing_model == 'full_factored' && $fabric->not_full_factored == TRUE) || $this->pricing_model == 'standard')
	// 				    $colourwayCost = $colourwayCost + Conversions::convertCurrency($fabric->fabrics->suppliers->currency, '£', $fabric->price * $fabric->meters, $this->styles->seasons);
	// 			}
	// 			$cost = $cost + $colourwayCost;
	// 		}
	// 		$cost = $cost / $this->colourways->count();
    //         switch($currencyOut){
    //             case '£':
    //                 return number_format((float)$cost, 2, '.', '');
    //             case '€':
    //                 return number_format((float)Conversions::convertCurrency('£', '€', $cost, $this->styles->seasons), 2, '.', '');
    //             case '$':
    //                 return number_format((float)Conversions::convertCurrency('£', '$', $cost, $this->styles->seasons), 2, '.', '');
    //         }

	// 	}
	// 	else
	// 		return 0;
    // }

    // public function composition(){
	// 	$colourway = $this->colourways->first();
	// 	$composition = [];
	// 	if(!$colourway == NULL){
	// 		foreach($colourway->colourway_yarns as $yarnLine){
    //             //dd($yarnLine->yarn_colours->yarn);
	// 			foreach($yarnLine->yarn_colours->yarn->yarn_compositions as $material){
    //                 //dd($yarnLine->percentage);
	// 				if(!($composition[$material->materials_id] ?? null)){ //if array key exists
	// 					$composition[$material->materials_id] = ['material' => 0, 'percentage' => 0];
	// 				}
	// 				$composition[$material->materials_id]['material'] = $material->materials->material;
	// 				$composition[$material->materials_id]['percentage'] = $composition[$material->materials_id]['percentage'] + (($material->percentage/100) * ($yarnLine->percentage/100) * 100);
	// 			}
	// 		}
	// 	}
	// 	$composition = collect($composition);
	// 	return $composition;
    // }

    // public function accessoryCost($currencyOut){
	// 	if(!$this->colourways->isEmpty()){
	// 		$cost = 0;
	// 		foreach($this->colourways as $i=>$colourway){
	// 			$colourwayCost = 0;
	// 			foreach($colourway->colourway_accessories as $accessory){
    //                 if(($this->pricing_model == 'full_factored' && $accessory->not_full_factored == TRUE) || $this->pricing_model == 'standard')
	// 				    $colourwayCost = $colourwayCost + Conversions::convertCurrency($accessory->accessories->suppliers->currency, '£', $accessory->price * $accessory->qty, $this->styles->seasons);
	// 			}
	// 			$cost = $cost + $colourwayCost;
	// 		}
	// 		$cost = $cost / $this->colourways->count();
	// 		switch($currencyOut){
    //             case '£':
    //                 return number_format((float)$cost, 2, '.', '');
    //             case '€':
    //                 return number_format((float)Conversions::convertCurrency('£', '€', $cost, $this->styles->seasons), 2, '.', '');
    //             case '$':
    //                 return number_format((float)Conversions::convertCurrency('£', '$', $cost, $this->styles->seasons), 2, '.', '');
    //         }
	// 	}
	// 	else
	// 		return 0;
	// }

    // public function weightAccepted(){
	// 	// $weight = 0;
	// 	// if(!$this->samples->sortByDesc('date_expected')->isEmpty())
	// 	// 	$weight = $this->samples->sortByDesc('date_expected')->first()->weight;
	// 	return $this->est_weight;
	// }

    // public function costedWeight(){
	// 	$weight = $this->weightAccepted();
	// 	if($this->costed_weight_percentage != "" || $this->costed_weight_percentage != NULL)
	// 		$weight = $weight + ($weight * $this->costed_weight_percentage/100);
	// 	else
	// 		$weight = 0;
	// 	return $weight;
	// }

    // public function gmtCost($currencyOut){
    //     if($this->pricing_model == 'estimate'){
    //         $cost = (($this->est_yarn + Conversions::convertCurrency($this->yarn_transportation_currency, '£', $this->yarn_transportation_cost, $this->styles->seasons)) * $this->est_weight)
    //         + $this->est_accessory + $this->est_fabric + Conversions::convertCurrency($this->cmt_currency, '£', $this->cmt, $this->styles->seasons)
    //         + (Conversions::convertCurrency($this->cmt_currency, '£', $this->cmt, $this->styles->seasons) * ($this->area_office_commission/100));
    //         $cost = $cost + $this->customs_cost + $this->other_costs;
    //     }
    //     else{
    //         $cost = (($this->yarnCost('£') + Conversions::convertCurrency($this->yarn_transportation_currency, '£', $this->yarn_transportation_cost, $this->styles->seasons)) * $this->costedWeight());
    //         $cost = $cost + $this->accessoryCost('£');
    //         $cost = $cost + $this->fabricCost('£') + Conversions::convertCurrency($this->cmt_currency, '£', $this->cmt, $this->styles->seasons)
    //         + (Conversions::convertCurrency($this->cmt_currency, '£', $this->cmt, $this->styles->seasons) * ($this->area_office_commission /100));
    //         $cost = $cost +  Conversions::convertCurrency($this->gmt_transportation_currency, '£', $this->transport_cost, $this->styles->seasons);
    //         $cost = $cost + $this->customs_cost + $this->other_costs;
    //     }
    //     switch($currencyOut){
    //         case '£':
    //             return number_format((float)$cost, 2, '.', '');
    //         case '€':
    //             return number_format((float)Conversions::convertCurrency('£', '€', $cost, $this->styles->seasons), 2, '.', '');
    //         case '$':
    //             return number_format((float)Conversions::convertCurrency('£', '$', $cost, $this->styles->seasons), 2, '.', '');
    //     }
    // }

    // public function quoteReccomended($currencyOut){
    //     $cost = $this->gmtCost('£') / (1 - ($this->styles->seasons->markup/100));
    //     switch($currencyOut){
    //         case '£':
    //             return number_format((float)$cost, 2, '.', '');
    //         case '€':
    //             return number_format((float)Conversions::convertCurrency('£', '€', $cost, $this->styles->seasons), 2, '.', '');
    //         case '$':
    //             return number_format((float)Conversions::convertCurrency('£', '$', $cost, $this->styles->seasons), 2, '.', '');
    //     }
    // }

    // public function quoteMargin(){ //ADD CURRENCY VERSIONS?
    //     if($this->quoteCurrency('£') != 0)
	// 		return number_format((float)(($this->quoteCurrency('£') - $this->gmtCost('£')) / $this->quoteCurrency('£')) * 100, 0, '.', '');
    // }

    // public function quoteCurrency($currencyOut){
    //     $quote = $this->quote;
    //     switch($currencyOut){
    //         case '£':
    //             return number_format((float)$quote, 2, '.', '');
    //         case '€':
    //             return number_format((float)Conversions::convertCurrency('£', '€', $quote, $this->styles->seasons), 2, '.', '');
    //         case '$':
    //             return number_format((float)Conversions::convertCurrency('£', '$', $quote, $this->styles->seasons), 2, '.', '');
    //     }
    // }

    // public function getYarns(){
    //     $yarns = [];
    //     foreach($this->colourways as $colourway){
    //         foreach($colourway->colourway_yarns as $yarn){
    //             $yarns[] = ['colour_id' => $yarn->yarn_colours->id, 'count' => $yarn->yarn_colours->yarn->counts->count, 'description' => $yarn->yarn_colours->yarn->description, 'colour' => $yarn->yarn_colours->reference . ' ' . $yarn->yarn_colours->description];
    //         }
    //     }
    //     $collection = collect($yarns);

    //     $unique = $collection->unique(function ($item) {
    //         return $item['description'].$item['colour'];
    //     });

    //     return $unique;
    // }

    // public function getYarnsNoColour(){
    //     $yarns = [];
    //     foreach($this->colourways as $colourway){
    //         foreach($colourway->colourway_yarns as $yarn){
    //             $yarns[] = ['count' => $yarn->yarn_colours->yarn->counts->count, 'description' => $yarn->yarn_colours->yarn->description,];
    //         }
    //     }
    //     $collection = collect($yarns);

    //     $unique = $collection->unique(function ($item) {
    //         return $item['description'];
    //     });

    //     return $unique;
    // }

    // public function getYarnsItem(){
    //     $yarns = [];
    //     foreach($this->colourways as $colourway){
    //         foreach($colourway->colourway_yarns as $yarn){
    //             $yarns[] = $yarn;
    //         }
    //     }
    //     $collection = collect($yarns);

    //     $unique = $collection->unique();
    //     // dd($unique);
    //     return $unique;
    // }

    protected static function invalidatePriceResolutions($styleVersion)
    {
        try {
            $service = app(\App\Services\PriceResolutionService::class);
            $service->invalidateByStyleVersion($styleVersion->id);
        } catch (\Exception $e) {
            \Log::error('Failed to invalidate price resolutions for style version', [
                'style_version_id' => $styleVersion->id,
                'error' => $e->getMessage()
            ]);
        }
    }

}
