<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('custom_sessions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('custom_request_id')->constrained()->onDelete('cascade');
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->string('title');
            $table->text('description')->nullable();
            $table->text('transcript')->nullable();
            $table->string('audio_path');
            $table->string('image_path')->nullable();
            $table->integer('duration_seconds')->default(0);
            $table->string('status')->default('queued'); // queued, generating, ready, failed
            $table->json('generation_metadata')->nullable();
            $table->timestamp('generated_at')->nullable();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('custom_sessions');
    }
};
