/** @type {import('tailwindcss').Config} */
module.exports = {
  content: [
    "./public/**/*.html",
    "./src/**/*.html"
  ],
  theme: {
    extend: {
      colors: {
        accent: {
          50: '#eef8ff',
          100: '#d9efff',
          200: '#b3dfff',
          300: '#86caff',
          400: '#57b1ff',
          500: '#2d95ff',
          600: '#1678e6',
          700: '#115fba',
          800: '#104f96',
          900: '#0f427a'
        }
      },
      borderRadius: {
        'xl': '0.75rem',
        '2xl': '1rem',
      },
      boxShadow: {
        'soft': '0 4px 16px rgba(0,0,0,0.06)'
      }
    },
    container: {
      center: true,
      padding: {
        DEFAULT: '1rem',
        lg: '2rem'
      }
    },
    fontFamily: {
      sans: [
        '-apple-system','BlinkMacSystemFont','Segoe UI','Roboto','Oxygen','Ubuntu','Cantarell','Fira Sans','Droid Sans','Helvetica Neue','sans-serif'
      ]
    }
  },
  corePlugins: {
    preflight: true
  }
}


