<?php

namespace App\Livewire;

use Livewire\Component;
use Illuminate\Support\Facades\Cookie;

class BasketCount extends Component
{
    public $count = 0;

    protected $listeners = ['basket-updated' => 'updateCount'];

    public function mount()
    {
        $this->updateCount();
    }

    public function updateCount()
    {
        $basketCookie = Cookie::get('basket', '[]');
        $basketData = json_decode($basketCookie, true);
        
        $this->count = array_sum(array_column($basketData, 'quantity'));
    }

    public function render()
    {
        return view('livewire.basket-count');
    }
}
