<?php

namespace App\Livewire;

use Livewire\Component;
use Livewire\Attributes\On;

class BasketCount extends Component
{
    public $count = 0;

    public function mount()
    {
        $this->updateCount();
    }

    #[On('basket-updated')]
    public function updateCount()
    {
        $basket = json_decode(request()->cookie('basket', '[]'), true);
        $this->count = is_array($basket) ? array_sum(array_column($basket, 'quantity')) : 0;
    }

    public function render()
    {
        return view('livewire.basket-count');
    }
}
