<?php

namespace App\Observers;

use App\Models\StatementTransaction;
use App\Services\AI\FinanceClassificationAgent;

class StatementTransactionObserver
{
    public function __construct(private FinanceClassificationAgent $agent) {}

    public function updated(StatementTransaction $transaction): void
    {
        // Check if department or account was changed by user
        if ($transaction->isDirty(['department_id', 'account_id'])) {
            $original = $transaction->getOriginal();
            $meta = is_array($transaction->meta) ? $transaction->meta : (empty($transaction->meta) ? [] : json_decode($transaction->meta, true));
            
            // Only learn if AI had made a suggestion
            if (isset($meta['ai_classification'])) {
                $correction = [
                    'original_department_id' => $original['department_id'] ?? null,
                    'corrected_department_id' => $transaction->department_id,
                    'original_account_id' => $original['account_id'] ?? null,
                    'corrected_account_id' => $transaction->account_id,
                ];
                
                // Learn from this correction
                $this->agent->learnFromCorrection($transaction, $correction);
            }
        }
    }
}

