@extends('layouts.frontend')

@section('meta_title', ucfirst($page) . ' - My Account - Yarn Store')

@section('content')
<div class="container py-5">
    <div class="row">
        <div class="col-12">
            <nav class="ys-breadcrumb">
                <a href="{{ route('home') }}">Home</a>
                <span>/</span>
                <span>My Account</span>
                <span>/</span>
                <span>{{ ucfirst($page) }}</span>
            </nav>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-8 mx-auto">
            <div class="ys-card p-5 text-center">
                <svg xmlns="http://www.w3.org/2000/svg" width="64" height="64" fill="var(--ys-primary)" class="mb-3" viewBox="0 0 16 16">
                    <path d="M8 8a3 3 0 1 0 0-6 3 3 0 0 0 0 6zm2-3a2 2 0 1 1-4 0 2 2 0 0 1 4 0zm4 8c0 1-1 1-1 1H3s-1 0-1-1 1-4 6-4 6 3 6 4zm-1-.004c-.001-.246-.154-.986-.832-1.664C11.516 10.68 10.289 10 8 10c-2.29 0-3.516.68-4.168 1.332-.678.678-.83 1.418-.832 1.664h10z"/>
                </svg>
                <h1 class="h3 fw-bold mb-3">{{ ucfirst($page) }}</h1>
                <p class="text-muted mb-4">
                    This section is currently under development and will be available soon.
                </p>
                <div class="d-flex gap-2 justify-content-center flex-wrap">
                    <a href="{{ route('home') }}" class="btn btn-ys-primary">
                        Return to Home
                    </a>
                    <a href="{{ route('collections') }}" class="btn btn-ys-secondary">
                        Browse Collections
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

