<?php
$meta = [
  'title' => 'Software Development & AI Integrations | Newcastle',
  'description' => 'Practical PHP web apps and AI integrations for small businesses in Newcastle, Killingworth, West Moor, and Forest Hall.',
  'canonical' => 'https://neilwiddowson.co.uk/services/software-dev.php'
];
$currentPage = 'services';
include __DIR__.'/../includes/header.php';
?>

<main id="main-content" class="section">
  <div class="container max-w-4xl">
    <h1 class="text-3xl font-bold tracking-tight">Software development & AI integrations.</h1>
    <p class="mt-4 text-gray-700">Stop wasting time on repetitive tasks. I build custom PHP web apps and AI-powered automations that streamline your business processes and boost productivity.</p>
    
    <div class="mt-8 grid gap-8 lg:grid-cols-2">
      <div>
        <h2 class="text-xl font-semibold text-gray-900 mb-4">What I build</h2>
        <ul class="space-y-3 text-gray-700">
          <li class="flex items-start gap-3">
            <svg class="h-5 w-5 text-accent-600 mt-0.5 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
              <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
            </svg>
            <span>Custom PHP web applications & dashboards</span>
          </li>
          <li class="flex items-start gap-3">
            <svg class="h-5 w-5 text-accent-600 mt-0.5 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
              <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
            </svg>
            <span>AI-powered workflow automation</span>
          </li>
          <li class="flex items-start gap-3">
            <svg class="h-5 w-5 text-accent-600 mt-0.5 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
              <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
            </svg>
            <span>API integrations (CRM, email, payments)</span>
          </li>
          <li class="flex items-start gap-3">
            <svg class="h-5 w-5 text-accent-600 mt-0.5 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
              <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
            </svg>
            <span>Data processing & reporting tools</span>
          </li>
        </ul>
      </div>
      
      <div>
        <h2 class="text-xl font-semibold text-gray-900 mb-4">Why choose custom software?</h2>
        <ul class="space-y-3 text-gray-700">
          <li class="flex items-start gap-3">
            <svg class="h-5 w-5 text-accent-600 mt-0.5 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
              <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
            </svg>
            <span>Replace clunky spreadsheets with smart tools</span>
          </li>
          <li class="flex items-start gap-3">
            <svg class="h-5 w-5 text-accent-600 mt-0.5 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
              <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
            </svg>
            <span>Automate repetitive admin tasks</span>
          </li>
          <li class="flex items-start gap-3">
            <svg class="h-5 w-5 text-accent-600 mt-0.5 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
              <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
            </svg>
            <span>Connect your existing systems seamlessly</span>
          </li>
          <li class="flex items-start gap-3">
            <svg class="h-5 w-5 text-accent-600 mt-0.5 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
              <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
            </svg>
            <span>Boost team productivity & accuracy</span>
          </li>
        </ul>
      </div>
    </div>

    <div class="mt-12">
      <h2 class="text-2xl font-bold text-gray-900 mb-6">Software Development Pricing</h2>
      <div class="grid gap-6 sm:grid-cols-2">
        <div class="pricing-card">
          <h3 class="text-lg font-semibold text-gray-900">AI Workflow Automation</h3>
          <p class="mt-1 text-3xl font-bold text-gray-900">from £350 / day</p>
          <ul class="mt-4 space-y-2 text-sm text-gray-700 list-disc list-inside">
            <li>Connect systems & APIs seamlessly</li>
            <li>AI-powered task automation</li>
            <li>Eliminate repetitive manual work</li>
            <li>Boost team productivity & accuracy</li>
          </ul>
          <div class="mt-auto pt-6"><a href="/contact/" class="btn-primary w-full">Start automation</a></div>
        </div>
        <div class="pricing-card pricing-featured">
          <h3 class="text-lg font-semibold text-gray-900">Custom Web Applications</h3>
          <p class="mt-1 text-3xl font-bold text-gray-900">from £995</p>
          <ul class="mt-4 space-y-2 text-sm text-gray-700 list-disc list-inside">
            <li>Replace clunky spreadsheets & forms</li>
            <li>Custom dashboards & data tools</li>
            <li>Secure user authentication</li>
            <li>Real-time data integration</li>
          </ul>
          <div class="mt-auto pt-6"><a href="/contact/" class="btn-primary w-full">Build my app</a></div>
        </div>
      </div>
    </div>

    <div class="mt-12 text-center">
      <h2 class="text-xl font-semibold text-gray-900 mb-4">Ready to streamline your business?</h2>
      <p class="text-gray-600 mb-6">Let's discuss how custom software can save you time and boost productivity.</p>
      <div class="flex flex-col sm:flex-row gap-3 justify-center">
        <a class="btn-primary" href="/contact/">Get a free quote</a>
        <a class="btn-secondary" href="/portfolio/">View portfolio</a>
      </div>
    </div>
  </div>
</main>

<?php include __DIR__.'/../includes/footer.php'; ?>
