<?php

namespace App\Http\Livewire\Sales\Orders;

use Livewire\Component;
use Livewire\Attributes\On;
use Livewire\Attributes\Computed;
use App\Models\CustomerOrderLines;
use App\Http\Livewire\BaseComponent;
use App\Livewire\Forms\OrdersEditLineDevForm;

class OrdersEditLine extends BaseComponent
{
    public OrdersEditLineDevForm $form;
    public $advanced = FALSE, $customer, $splitDrops = [];

    public function render()
    {
        return view('livewire.sales.orders.orders-edit-line-dev');
    }

    #[On('clear-line')]
    public function clearLine(){
        $this->reset();
    }


    #[On('edit-line')]
    public function mount($id = FALSE, $orderType = 'wholesale'){
        // dd($id);
        if($id){
            $line = CustomerOrderLines::with([
                'customer_order_line_quantities:id,customer_order_lines_id,sizes_id,qty,SKU,barcode,price,commission,discount' => [
                    'sizes:id,name'
                ],
                'colourways:id,style_versions_id,name,cancelled,colour_type' => [
                    'style_versions:id,factory_id,styles_id,name' => [
                        'styles:id,designs_id,customer_ref' => [
                            'designs:id,description'
                        ],
                        'factories:id,name',
                        'prices:id,style_versions_id,quote',
                    ],
                ],
                'shipment_lines:id,customer_order_lines_id,exfty' => [
                    'shipment_line_sizes:id,sizes_id,shipment_line_id,qty,shipped_qty' => [
                        'sizes:id,name'
                    ],
                ],
                'customer_orders:id,customers_id' => [
                    'customers:id,settings,currency,default_discount,default_commission'
                ]
            ])->find($id);
            if($line){
                $this->form->open($line, $orderType);
                $this->customer = $line->customer_orders->customers;
                // dd($line->customer_orders->customers);
            }
        }
    }

    #[On('toggle-advanced-order')]
    public function toggleAdvanced(){
        $this->advanced = !$this->advanced;
    }

    #[Computed]
    public function viewOnly(){
        return $this->form->viewOnly();
    }


    #[On('save-order-line')]
    #[On('save-order')]
    public function saveOrder(){
        if(!empty($this->form->orderLineEdit))
            $this->form->save();
    }

    public function removeSize($s){
        $this->form->removeSize($s);
    }

    public function addSize(){
        $this->form->addSize();
    }

    public function addCustSizes(){
        $this->form->addCustSizes($this->customer);
    }

    public function addDrop(){
        $this->form->addDrop();
    }
    public function deleteDrop($d, $drop = NULL){
        $this->form->deleteDrop($d, $drop);
    }

    public function splitDropIntoNewOrder($dropIndex){
        $this->form->splitDropIntoNewOrder($dropIndex);
    }
}
