<!doctype html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <!-- SEO Meta Tags -->
    <title>@yield('title', 'Yarn Store - Premium Yarns by Robert Todd Yarn')</title>
    <meta name="description" content="@yield('meta_description', 'Discover premium quality yarns at Yarn Store. Browse our collections by season and find the perfect yarn for your next project.')">
    <meta name="keywords" content="@yield('meta_keywords', 'yarn, wool, knitting, crochet, premium yarn, Robert Todd Yarn')">
    <meta name="author" content="Robert Todd Yarn">
    
    <!-- Open Graph / Social Media Meta Tags -->
    <meta property="og:type" content="website">
    <meta property="og:title" content="@yield('og_title', 'Yarn Store - Premium Yarns by Robert Todd Yarn')">
    <meta property="og:description" content="@yield('og_description', 'Discover premium quality yarns at Yarn Store.')">
    <meta property="og:image" content="@yield('og_image', asset('images/og-default.jpg'))">
    <meta property="og:url" content="{{ url()->current() }}">
    
    <!-- Twitter Card Meta Tags -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="@yield('twitter_title', 'Yarn Store - Premium Yarns')">
    <meta name="twitter:description" content="@yield('twitter_description', 'Discover premium quality yarns at Yarn Store.')">
    
    <!-- Canonical URL -->
    <link rel="canonical" href="{{ url()->current() }}">
    
    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="{{ asset('favicon.ico') }}">

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=inter:400,500,600,700|playfair-display:700" rel="stylesheet">

    <!-- Styles -->
    @vite(['resources/sass/app.scss', 'resources/js/app.js'])
    @livewireStyles
    
    <!-- Structured Data -->
    @stack('structured_data')
</head>
<body>
    <div id="app">
        <!-- Top Bar -->
        <div class="bg-primary text-white py-2">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-md-6 text-center text-md-start">
                        <small>Yarns spun to order by our spinners worldwide • Delivered fresh to your door</small>
                    </div>
                    <div class="col-md-6 text-center text-md-end">
                        <small>Need help? Call us: 01234 567890</small>
                    </div>
                </div>
            </div>
        </div>

        <!-- Main Navigation -->
        <nav class="ys-navbar sticky-top">
            <div class="container py-3">
                <div class="row align-items-center">
                    <!-- Logo -->
                    <div class="col-lg-3 col-md-4 col-6">
                        <a href="{{ route('home') }}" class="navbar-brand d-flex align-items-center text-decoration-none">
                            <h1 class="h3 mb-0 fw-bold" style="color: var(--ys-primary);">
                                <span class="d-inline-block">Yarn Store</span>
                            </h1>
                        </a>
                        <small class="text-muted d-block" style="font-size: 0.75rem; margin-top: -5px;">by Robert Todd Yarn</small>
                    </div>

                    <!-- Search Bar (Desktop) -->
                    <div class="col-lg-5 d-none d-lg-block">
                        @livewire('search-bar')
                    </div>

                    <!-- Right Side Icons -->
                    <div class="col-lg-4 col-md-8 col-6">
                        <div class="d-flex justify-content-end align-items-center gap-3">
                            <!-- Account -->
                            <div class="dropdown">
                                <a href="#" class="text-decoration-none ys-nav-link dropdown-toggle" data-bs-toggle="dropdown">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                        <path d="M20 21v-2a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v2"></path>
                                        <circle cx="12" cy="7" r="4"></circle>
                                    </svg>
                                    <span class="d-none d-md-inline ms-1">Account</span>
                                </a>
                                <ul class="dropdown-menu dropdown-menu-end">
                                    @auth
                                        <li><a class="dropdown-item" href="{{ route('account.dashboard') }}">My Account</a></li>
                                        <li><a class="dropdown-item" href="{{ route('account.orders') }}">My Orders</a></li>
                                        <li><a class="dropdown-item" href="{{ route('account.profile') }}">Profile</a></li>
                                        <li><hr class="dropdown-divider"></li>
                                        @if(Auth::user()->isAdmin())
                                            <li><a class="dropdown-item" href="{{ route('admin.dashboard') }}">Admin Panel</a></li>
                                            <li><hr class="dropdown-divider"></li>
                                        @endif
                                        <li>
                                            <form method="POST" action="{{ route('logout') }}">
                                                @csrf
                                                <button type="submit" class="dropdown-item">Logout</button>
                                            </form>
                                        </li>
                                    @else
                                        <li><a class="dropdown-item" href="{{ route('login') }}">Login</a></li>
                                        <li><a class="dropdown-item" href="{{ route('register') }}">Register</a></li>
                                    @endauth
                                </ul>
                            </div>

                            <!-- Basket -->
                            <a href="{{ route('basket') }}" class="text-decoration-none ys-nav-link position-relative">
                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                    <circle cx="9" cy="21" r="1"></circle>
                                    <circle cx="20" cy="21" r="1"></circle>
                                    <path d="M1 1h4l2.68 13.39a2 2 0 0 0 2 1.61h9.72a2 2 0 0 0 2-1.61L23 6H6"></path>
                                </svg>
                                <span class="d-none d-md-inline ms-1">Basket</span>
                                @livewire('basket-count')
                            </a>
                        </div>
                    </div>
                </div>

                <!-- Search Bar (Mobile) -->
                <div class="row mt-3 d-lg-none">
                    <div class="col-12">
                        @livewire('search-bar')
                    </div>
                </div>

                <!-- Main Menu -->
                <div class="row mt-3">
                    <div class="col-12">
                        <ul class="nav justify-content-center gap-4">
                            <li class="nav-item dropdown">
                                <a class="nav-link ys-nav-link dropdown-toggle" href="#" data-bs-toggle="dropdown">
                                    Collections
                                </a>
                                <ul class="dropdown-menu">
                                    @php
                                        $seasons = \App\Models\Season::orderBy('sort_order')->get();
                                    @endphp
                                    @foreach($seasons as $season)
                                        <li><a class="dropdown-item" href="{{ route('shop.season', $season->slug) }}">{{ $season->name }}</a></li>
                                    @endforeach
                                    <li><hr class="dropdown-divider"></li>
                                    <li><a class="dropdown-item" href="{{ route('shop.all') }}">View All Products</a></li>
                                </ul>
                            </li>
                            <li class="nav-item dropdown">
                                <a class="nav-link ys-nav-link dropdown-toggle" href="#" data-bs-toggle="dropdown">
                                    Categories
                                </a>
                                <ul class="dropdown-menu">
                                    @php
                                        $categories = \App\Models\Category::orderBy('sort_order')->get();
                                    @endphp
                                    @foreach($categories as $category)
                                        <li><a class="dropdown-item" href="{{ route('shop.category', $category->slug) }}">{{ $category->name }}</a></li>
                                    @endforeach
                                </ul>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link ys-nav-link" href="{{ route('about') }}">About Us</a>
                            </li>
                            <li class="nav-item dropdown">
                                <a class="nav-link ys-nav-link dropdown-toggle" href="#" data-bs-toggle="dropdown">
                                    Guides & Help
                                </a>
                                <ul class="dropdown-menu">
                                    <li><a class="dropdown-item" href="{{ route('guides.care') }}">Yarn Care Guide</a></li>
                                    <li><a class="dropdown-item" href="{{ route('guides.choosing') }}">Choosing Your Yarn</a></li>
                                    <li><a class="dropdown-item" href="{{ route('guides.patterns') }}">Free Patterns</a></li>
                                    <li><hr class="dropdown-divider"></li>
                                    <li><a class="dropdown-item" href="{{ route('faq') }}">FAQs</a></li>
                                </ul>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link ys-nav-link" href="{{ route('contact') }}">Contact</a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </nav>

        <!-- Main Content -->
        <main>
            @hasSection('content')
                @yield('content')
            @else
                {{ $slot }}
            @endif
        </main>

        <!-- Footer -->
        <footer class="ys-footer">
            <div class="container">
                <div class="row">
                    <!-- About Column -->
                    <div class="col-lg-3 col-md-6 mb-4">
                        <h5 class="fw-bold mb-3">Yarn Store</h5>
                        <p class="small">Premium quality yarns for knitting and crochet enthusiasts. Bringing you the finest yarns from around the world.</p>
                        <p class="small mb-0"><strong>Robert Todd Yarn Ltd</strong></p>
                    </div>

                    <!-- Shop Links -->
                    <div class="col-lg-2 col-md-6 mb-4">
                        <h5 class="fw-bold mb-3">Shop</h5>
                        <ul class="list-unstyled">
                            <li class="mb-2"><a href="{{ route('shop.all') }}" class="text-white text-decoration-none small">All Products</a></li>
                            @foreach($seasons ?? [] as $season)
                                <li class="mb-2"><a href="{{ route('shop.season', $season->slug) }}" class="text-white text-decoration-none small">{{ $season->name }}</a></li>
                            @endforeach
                        </ul>
                    </div>

                    <!-- Customer Service -->
                    <div class="col-lg-2 col-md-6 mb-4">
                        <h5 class="fw-bold mb-3">Help & Info</h5>
                        <ul class="list-unstyled">
                            <li class="mb-2"><a href="{{ route('contact') }}" class="text-white text-decoration-none small">Contact Us</a></li>
                            <li class="mb-2"><a href="{{ route('shipping') }}" class="text-white text-decoration-none small">Shipping Info</a></li>
                            <li class="mb-2"><a href="{{ route('returns') }}" class="text-white text-decoration-none small">Returns Policy</a></li>
                            <li class="mb-2"><a href="{{ route('faq') }}" class="text-white text-decoration-none small">FAQs</a></li>
                        </ul>
                    </div>

                    <!-- Legal -->
                    <div class="col-lg-2 col-md-6 mb-4">
                        <h5 class="fw-bold mb-3">Legal</h5>
                        <ul class="list-unstyled">
                            <li class="mb-2"><a href="{{ route('terms') }}" class="text-white text-decoration-none small">Terms & Conditions</a></li>
                            <li class="mb-2"><a href="{{ route('privacy') }}" class="text-white text-decoration-none small">Privacy Policy</a></li>
                            <li class="mb-2"><a href="{{ route('cookies') }}" class="text-white text-decoration-none small">Cookie Policy</a></li>
                            <li class="mb-2"><a href="{{ route('gdpr') }}" class="text-white text-decoration-none small">GDPR</a></li>
                        </ul>
                    </div>

                    <!-- Contact Info -->
                    <div class="col-lg-3 col-md-6 mb-4">
                        <h5 class="fw-bold mb-3">Get In Touch</h5>
                        <ul class="list-unstyled small">
                            <li class="mb-2">
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="me-2">
                                    <path d="M22 16.92v3a2 2 0 0 1-2.18 2 19.79 19.79 0 0 1-8.63-3.07 19.5 19.5 0 0 1-6-6 19.79 19.79 0 0 1-3.07-8.67A2 2 0 0 1 4.11 2h3a2 2 0 0 1 2 1.72 12.84 12.84 0 0 0 .7 2.81 2 2 0 0 1-.45 2.11L8.09 9.91a16 16 0 0 0 6 6l1.27-1.27a2 2 0 0 1 2.11-.45 12.84 12.84 0 0 0 2.81.7A2 2 0 0 1 22 16.92z"></path>
                                </svg>
                                01234 567890
                            </li>
                            <li class="mb-2">
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="me-2">
                                    <path d="M4 4h16c1.1 0 2 .9 2 2v12c0 1.1-.9 2-2 2H4c-1.1 0-2-.9-2-2V6c0-1.1.9-2 2-2z"></path>
                                    <polyline points="22,6 12,13 2,6"></polyline>
                                </svg>
                                info@yarnstore.co.uk
                            </li>
                        </ul>
                        
                        <!-- Newsletter Signup -->
                        <div class="mt-3">
                            <h6 class="fw-bold mb-2">Newsletter</h6>
                            @livewire('newsletter-signup')
                        </div>
                    </div>
                </div>

                <hr class="my-4 border-light opacity-25">

                <!-- Bottom Bar -->
                <div class="row">
                    <div class="col-md-6 text-center text-md-start">
                        <p class="small mb-0">&copy; {{ date('Y') }} Robert Todd Yarn Ltd. All rights reserved.</p>
                    </div>
                    <div class="col-md-6 text-center text-md-end">
                        <p class="small mb-0">Registered in England & Wales | Company No: 12345678</p>
                    </div>
                </div>
            </div>
        </footer>

        <!-- Cookie Consent Banner -->
        @livewire('cookie-consent')
    </div>

    @livewireScripts
    @stack('scripts')
</body>
</html>

