<?php

namespace App\Providers;

use App\Models\Team;
use App\Models\User;
use App\Policies\TeamPolicy;
use Illuminate\Support\Facades\Gate;
use Illuminate\Support\Facades\Cache;
use Illuminate\Foundation\Support\Providers\AuthServiceProvider as ServiceProvider;

class AuthServiceProvider extends ServiceProvider
{
    /**
     * The policy mappings for the application.
     *
     * @var array
     */
    protected $policies = [
        Team::class => TeamPolicy::class,
    ];


    protected $teams = [];

    /**
     * Register any authentication / authorization services.
     *
     * @return void
     */
    public function boot()
    {
        // Only load teams if database is available and table exists
        try {
            if (Schema::hasTable('teams')) {
                $teams = Team::all();

                $this->teams['rt'] = $teams->where('id', 1)->first();
                $this->teams['design'] = $teams->where('id', 2)->first();
                $this->teams['development'] = $teams->where('id', 3)->first();
                $this->teams['pricing'] = $teams->where('id', 4)->first();
                $this->teams['merchandising'] = $teams->where('id', 5)->first();
            }
        } catch (\Exception $e) {
            // Log the error but don't crash the application
            \Log::warning('Could not load teams in AuthServiceProvider: ' . $e->getMessage());
        }
        $this->teams['finance'] = $teams->where('id', 6)->first();
        $this->teams['yc'] = $teams->where('id', 7)->first();

        //ROBERT TODD GROUP PERMISSIONS
        Gate::before(function ($user) {  //RT ADMIN
            if($user->hasTeamRole($this->teams['rt'], 'admin') == TRUE){
                return TRUE;
            }
        });

        //DESIGN PERMISSIONS
        Gate::define('design:create', function (User $user) {
            return $user->hasTeamPermission($this->teams['design'], 'create');
        });
        Gate::define('design:update', function (User $user) {
            return $user->hasTeamPermission($this->teams['design'], 'update');
        });
        Gate::define('design:delete', function (User $user) {
            return $user->hasTeamPermission($this->teams['design'], 'delete');
        });
        Gate::define('design:read', function (User $user) {
            return $user->hasTeamPermission($this->teams['design'], 'read');
        });

        //STYLE PERMISSIONS
        Gate::define('style:create', function (User $user) {
            return $user->hasTeamPermission($this->teams['development'], 'create');
        });
        Gate::define('style:update', function (User $user) {
            return $user->hasTeamPermission($this->teams['development'], 'update');
        });
        Gate::define('style:delete', function (User $user) {
            return $user->hasTeamPermission($this->teams['development'], 'delete');
        });
        Gate::define('style:read', function (User $user) {
            return $user->hasTeamPermission($this->teams['development'], 'read');
        });

        //PRICING PERMISSIONS
        Gate::define('price:create', function (User $user) {
            return $user->hasTeamPermission($this->teams['pricing'], 'create');
        });
        Gate::define('price:update', function (User $user) {
            return $user->hasTeamPermission($this->teams['pricing'], 'update');
        });
        Gate::define('price:delete', function (User $user) {
            return $user->hasTeamPermission($this->teams['pricing'], 'delete');
        });
        Gate::define('price:read', function (User $user) {
            return $user->hasTeamPermission($this->teams['pricing'], 'read');
        });

        //ORDERS PERMISSIONS
        Gate::define('order:create', function (User $user) {
            return $user->hasTeamPermission($this->teams['merchandising'], 'create');
        });
        Gate::define('order:update', function (User $user) {
            return $user->hasTeamPermission($this->teams['merchandising'], 'update');
        });
        Gate::define('order:delete', function (User $user) {
            return $user->hasTeamPermission($this->teams['merchandising'], 'delete');
        });
        Gate::define('order:read', function (User $user) {
            return $user->hasTeamPermission($this->teams['merchandising'], 'read');
        });

        //SHIPMENTS PERMISSIONS
        Gate::define('shipment:create', function (User $user) {
            return $user->hasTeamPermission($this->teams['merchandising'], 'create');
        });
        Gate::define('shipment:update', function (User $user) {
            return $user->hasTeamPermission($this->teams['merchandising'], 'update');
        });
        Gate::define('shipment:delete', function (User $user) {
            return $user->hasTeamPermission($this->teams['merchandising'], 'delete');
        });
        Gate::define('shipment:read', function (User $user) {
            return $user->hasTeamPermission($this->teams['merchandising'], 'read');
        });

        //FINANCE PERMISSIONS
        Gate::define('finance:create', function (User $user) {
            return $user->hasTeamPermission($this->teams['finance'], 'create');
        });
        Gate::define('finance:update', function (User $user) {
            return $user->hasTeamPermission($this->teams['finance'], 'update');
        });
        Gate::define('finance:delete', function (User $user) {
            return $user->hasTeamPermission($this->teams['finance'], 'delete');
        });
        Gate::define('finance:read', function (User $user) {
            return $user->hasTeamPermission($this->teams['finance'], 'read');
        });


        //YC PERMISSIONS
        Gate::define('yc:create', function (User $user) {
            return $user->hasTeamPermission($this->teams['yc'], 'create');
        });
        Gate::define('yc:update', function (User $user) {
            return $user->hasTeamPermission($this->teams['yc'], 'update');
        });
        Gate::define('yc:delete', function (User $user) {
            return $user->hasTeamPermission($this->teams['yc'], 'delete');
        });
        Gate::define('yc:read', function (User $user) {
            return $user->hasTeamPermission($this->teams['yc'], 'read');
        });


        //ADMIN-CUSTOMERS PERMISSIONS
        Gate::define('customer:create', function (User $user) {
            if($user->hasTeamPermission($this->teams['design'], 'create') ||
            $user->hasTeamPermission($this->teams['development'], 'create') ||
            $user->hasTeamPermission($this->teams['merchandising'], 'create') ||
            $user->hasTeamPermission($this->teams['finance'], 'create'))
                return true;
            else
                return false;
        });
        Gate::define('customer:update', function (User $user) {
            if($user->hasTeamPermission($this->teams['design'], 'update') ||
            $user->hasTeamPermission($this->teams['development'], 'update') ||
            $user->hasTeamPermission($this->teams['merchandising'], 'update') ||
            $user->hasTeamPermission($this->teams['finance'], 'update'))
                return true;
            else
                return false;
        });
        Gate::define('customer:read', function (User $user) {
            if($user->hasTeamPermission($this->teams['design'], 'read') ||
            $user->hasTeamPermission($this->teams['development'], 'read') ||
            $user->hasTeamPermission($this->teams['merchandising'], 'read') ||
            $user->hasTeamPermission($this->teams['finance'], 'read'))
                return true;
            else
                return false;
        });

        //ADMIN-SUPPLIERS PERMISSIONS
        Gate::define('supplier:create', function (User $user) {
            if($user->hasTeamPermission($this->teams['design'], 'create') ||
            $user->hasTeamPermission($this->teams['development'], 'create') ||
            $user->hasTeamPermission($this->teams['merchandising'], 'create') ||
            $user->hasTeamPermission($this->teams['finance'], 'create'))
                return true;
            else
                return false;
        });
        Gate::define('supplier:update', function (User $user) {
            if($user->hasTeamPermission($this->teams['design'], 'update') ||
            $user->hasTeamPermission($this->teams['development'], 'update') ||
            $user->hasTeamPermission($this->teams['merchandising'], 'update') ||
            $user->hasTeamPermission($this->teams['finance'], 'update'))
                return true;
            else
                return false;
        });
        Gate::define('supplier:read', function (User $user) {
            if($user->hasTeamPermission($this->teams['design'], 'read') ||
            $user->hasTeamPermission($this->teams['development'], 'read') ||
            $user->hasTeamPermission($this->teams['merchandising'], 'read') ||
            $user->hasTeamPermission($this->teams['finance'], 'read'))
                return true;
            else
                return false;
        });

        //ADMIN-DEPARTMENTS PERMISSIONS
        Gate::define('department:read', function (User $user) {
            if($user->hasTeamPermission($this->teams['design'], 'read') ||
            $user->hasTeamPermission($this->teams['development'], 'read') ||
            $user->hasTeamPermission($this->teams['merchandising'], 'read') ||
            $user->hasTeamPermission($this->teams['finance'], 'read'))
                return true;
            else
                return false;
        });

        //ADMIN-SEASONS PERMISSIONS
        Gate::define('season:read', function (User $user) {
            if($user->hasTeamPermission($this->teams['design'], 'read') ||
            $user->hasTeamPermission($this->teams['development'], 'read') ||
            $user->hasTeamPermission($this->teams['merchandising'], 'read') ||
            $user->hasTeamPermission($this->teams['finance'], 'read'))
                return true;
            else
                return false;
        });
        Gate::define('season:update', function (User $user) {
            if($user->hasTeamPermission($this->teams['finance'], 'update'))
                return true;
            else
                return false;
        });
    }
}
