<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('statement_transactions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('statement_id')->constrained('statements')->cascadeOnDelete();
            $table->string('cardholder_name');
            $table->string('account_number_masked')->index();
            $table->date('transaction_date')->index();
            $table->date('posted_date')->nullable()->index();
            $table->time('transaction_time')->nullable();
            $table->string('merchant_name');
            $table->decimal('amount', 12, 2);
            $table->string('currency', 3)->default('GBP');
            $table->decimal('original_amount', 12, 2)->nullable();
            $table->string('original_currency', 3)->nullable();
            $table->decimal('conversion_rate', 18, 9)->nullable();
            $table->string('authorisation_code')->nullable();
            $table->string('transaction_id')->nullable()->index();
            $table->string('merchant_category')->nullable();
            $table->string('transaction_type')->nullable();
            $table->string('mcc_description')->nullable();
            $table->string('merchant_city')->nullable();
            $table->string('merchant_state')->nullable();
            $table->string('merchant_postcode')->nullable();
            $table->string('mcc')->nullable()->index();
            $table->string('statement_cycle')->nullable();
            $table->boolean('has_receipt')->default(false)->index();
            $table->foreignId('user_id')->nullable()->constrained('users')->nullOnDelete();
            $table->foreignId('department_id')->nullable()->constrained('departments')->nullOnDelete();
            $table->foreignId('account_id')->nullable()->constrained('accounts')->nullOnDelete();
            $table->boolean('is_personal')->default(false)->index();
            $table->json('meta')->nullable();
            $table->timestamps();
            $table->index(['statement_id', 'transaction_date', 'amount'], 'txn_match_search_idx');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('statement_transactions');
    }
};
