<?php

namespace App\Livewire;

use App\Models\CustomSession;
use Livewire\Component;
use Livewire\WithPagination;
use Livewire\Attributes\Title;
use Illuminate\Support\Facades\Auth;

class CustomSessionsList extends Component
{
    use WithPagination;

    public $search = '';
    public $statusFilter = '';

    protected $queryString = [
        'search' => ['except' => ''],
        'statusFilter' => ['except' => ''],
    ];

    public function updatedSearch()
    {
        $this->resetPage();
    }

    public function updatedStatusFilter()
    {
        $this->resetPage();
    }

    public function clearFilters()
    {
        $this->reset(['search', 'statusFilter']);
        $this->resetPage();
    }

    #[Title('My Custom Sessions - Vybe')]
    public function render()
    {
        $query = CustomSession::where('user_id', Auth::id())
            ->with(['customRequest']);

        // Apply search filter
        if ($this->search) {
            $query->where(function ($q) {
                $q->where('title', 'like', '%' . $this->search . '%')
                  ->orWhere('description', 'like', '%' . $this->search . '%');
            });
        }

        // Apply status filter
        if ($this->statusFilter) {
            $query->where('status', $this->statusFilter);
        }

        $sessions = $query->orderBy('created_at', 'desc')->paginate(10);

        return view('livewire.pages.custom-sessions-list', [
            'sessions' => $sessions,
        ]);
    }
}
